/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.services.sns.AmazonSNS;
import java.util.Collections;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.TopicMessageChannel;
import org.springframework.cloud.aws.messaging.core.support.AbstractMessageChannelMessagingSendingTemplate;
import org.springframework.cloud.aws.messaging.support.destination.DynamicTopicDestinationResolver;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.DestinationResolver;

public class NotificationMessagingTemplate
extends AbstractMessageChannelMessagingSendingTemplate<TopicMessageChannel> {
    private final AmazonSNS amazonSns;

    public NotificationMessagingTemplate(AmazonSNS amazonSns) {
        this(amazonSns, (ResourceIdResolver)null, null);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver) {
        this(amazonSns, resourceIdResolver, null);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver, MessageConverter messageConverter) {
        super(new DynamicTopicDestinationResolver(amazonSns, resourceIdResolver));
        this.amazonSns = amazonSns;
        this.initMessageConverter(messageConverter);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, DestinationResolver<String> destinationResolver, MessageConverter messageConverter) {
        super(destinationResolver);
        this.amazonSns = amazonSns;
        this.initMessageConverter(messageConverter);
    }

    @Override
    protected TopicMessageChannel resolveMessageChannel(String physicalResourceIdentifier) {
        return new TopicMessageChannel(this.amazonSns, physicalResourceIdentifier);
    }

    public void sendNotification(String destinationName, Object message, String subject) {
        this.convertAndSend(destinationName, message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }

    public void sendNotification(Object message, String subject) {
        this.convertAndSend(this.getRequiredDefaultDestination(), message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }
}

