/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.cloud.bus.event.Destination;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.event.UnknownRemoteApplicationEvent;

public class AckRemoteApplicationEvent
extends RemoteApplicationEvent {
    private final String ackId;
    private final String ackDestinationService;
    private Class<? extends RemoteApplicationEvent> event;

    private AckRemoteApplicationEvent() {
        this.ackDestinationService = null;
        this.ackId = null;
        this.event = null;
    }

    public AckRemoteApplicationEvent(Object source, String originService, Destination destination, String ackDestinationService, String ackId, Class<? extends RemoteApplicationEvent> type) {
        super(source, originService, destination);
        this.ackDestinationService = ackDestinationService;
        this.ackId = ackId;
        this.event = type;
    }

    public String getAckId() {
        return this.ackId;
    }

    public String getAckDestinationService() {
        return this.ackDestinationService;
    }

    public Class<? extends RemoteApplicationEvent> getEvent() {
        return this.event;
    }

    @JsonProperty(value="event")
    public void setEventName(String eventName) {
        try {
            this.event = Class.forName(eventName);
        }
        catch (ClassNotFoundException e) {
            this.event = UnknownRemoteApplicationEvent.class;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ackDestinationService == null ? 0 : this.ackDestinationService.hashCode());
        result = 31 * result + (this.ackId == null ? 0 : this.ackId.hashCode());
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AckRemoteApplicationEvent other = (AckRemoteApplicationEvent)((Object)obj);
        if (this.ackDestinationService == null ? other.ackDestinationService != null : !this.ackDestinationService.equals(other.ackDestinationService)) {
            return false;
        }
        if (this.ackId == null ? other.ackId != null : !this.ackId.equals(other.ackId)) {
            return false;
        }
        return !(this.event == null ? other.event != null : !this.event.equals(other.event));
    }
}

