/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.bus.ServiceMatcher;
import org.springframework.cloud.bus.event.ShutdownRemoteApplicationEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class ShutdownListener
implements ApplicationListener<ShutdownRemoteApplicationEvent>,
ApplicationContextAware {
    private static final Log LOG = LogFactory.getLog(ShutdownListener.class);
    private ApplicationContext context;
    private ServiceMatcher serviceMatcher;

    public ShutdownListener(ServiceMatcher serviceMatcher) {
        this.serviceMatcher = serviceMatcher;
    }

    public void onApplicationEvent(ShutdownRemoteApplicationEvent event) {
        if (this.serviceMatcher.isForSelf(event)) {
            LOG.warn((Object)("Received remote shutdown request from " + event.getOriginService() + ".  Shutting down."));
            this.shutdown();
        } else {
            LOG.info((Object)("Shutdown not performed, the event was targeting " + event.getDestinationService()));
        }
    }

    protected int shutdown() {
        return SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}

