/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.cloud.bus.BusAutoConfiguration;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.endpoint.RefreshBusEndpoint;
import org.springframework.cloud.bus.jackson.BusJacksonMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@ConditionalOnClass(value={RefreshBusEndpoint.class, ObjectMapper.class})
@AutoConfigureBefore(value={BusAutoConfiguration.class, JacksonAutoConfiguration.class})
public class BusJacksonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"busJsonConverter"})
    public AbstractMessageConverter busJsonConverter(@Autowired(required=false) ObjectMapper objectMapper) {
        return new BusJacksonMessageConverter(objectMapper);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CBORFactory.class})
    protected static class CborConfiguration {
        protected CborConfiguration() {
        }

        @Bean
        public AbstractMessageConverter busCborConverter() {
            return new BusJacksonMessageConverter(new MimeType("application", "cbor"), new ObjectMapper((JsonFactory)new CBORFactory()));
        }
    }
}

