/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.ArrayNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.BigIntegerNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.BinaryNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.BooleanNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.DecimalNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.DoubleNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.FloatNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.IntNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.JsonNodeCreator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.LongNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.NullNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.NumericNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.POJONode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.ShortNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.TextNode;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.node.ValueNode;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = -3271940633258788634L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bl) {
        this._cfgBigDecimalExact = bl;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl) {
        return bl ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte by) {
        return IntNode.valueOf(by);
    }

    @Override
    public ValueNode numberNode(Byte by) {
        return by == null ? this.nullNode() : IntNode.valueOf(by.intValue());
    }

    @Override
    public NumericNode numberNode(short s) {
        return ShortNode.valueOf(s);
    }

    @Override
    public ValueNode numberNode(Short s) {
        return s == null ? this.nullNode() : ShortNode.valueOf(s);
    }

    @Override
    public NumericNode numberNode(int n) {
        return IntNode.valueOf(n);
    }

    @Override
    public ValueNode numberNode(Integer n) {
        return n == null ? this.nullNode() : IntNode.valueOf(n);
    }

    @Override
    public NumericNode numberNode(long l) {
        if (this._inIntRange(l)) {
            return IntNode.valueOf((int)l);
        }
        return LongNode.valueOf(l);
    }

    @Override
    public ValueNode numberNode(Long l) {
        if (l == null) {
            return this.nullNode();
        }
        long l2 = l;
        return this._inIntRange(l2) ? IntNode.valueOf((int)l2) : LongNode.valueOf(l2);
    }

    @Override
    public NumericNode numberNode(BigInteger bigInteger) {
        return BigIntegerNode.valueOf(bigInteger);
    }

    @Override
    public NumericNode numberNode(float f) {
        return FloatNode.valueOf(f);
    }

    @Override
    public ValueNode numberNode(Float f) {
        return f == null ? this.nullNode() : FloatNode.valueOf(f.floatValue());
    }

    @Override
    public NumericNode numberNode(double d) {
        return DoubleNode.valueOf(d);
    }

    @Override
    public ValueNode numberNode(Double d) {
        return d == null ? this.nullNode() : DoubleNode.valueOf(d);
    }

    @Override
    public NumericNode numberNode(BigDecimal bigDecimal) {
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(bigDecimal.stripTrailingZeros());
    }

    @Override
    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray, int n, int n2) {
        return BinaryNode.valueOf(byArray, n, n2);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    @Deprecated
    public POJONode POJONode(Object object) {
        return new POJONode(object);
    }

    protected boolean _inIntRange(long l) {
        int n = (int)l;
        long l2 = n;
        return l2 == l;
    }
}

