/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.ServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.ServiceInfo;

public abstract class CloudFoundryServiceInfoCreator<SI extends ServiceInfo>
implements ServiceInfoCreator<SI, Map<String, Object>> {
    private Tags tags;
    private String[] uriSchemes;

    public CloudFoundryServiceInfoCreator(Tags tags, String ... uriSchemes) {
        this.tags = tags;
        this.uriSchemes = uriSchemes;
    }

    public boolean accept(Map<String, Object> serviceData) {
        return this.tagsMatch(serviceData) || this.labelStartsWithTag(serviceData) || this.uriMatchesScheme(serviceData) || this.uriKeyMatchesScheme(serviceData);
    }

    protected boolean tagsMatch(Map<String, Object> serviceData) {
        List serviceTags = (List)serviceData.get("tags");
        return this.tags.containsOne(serviceTags);
    }

    protected boolean labelStartsWithTag(Map<String, Object> serviceData) {
        String label = (String)serviceData.get("label");
        return this.tags.startsWith(label);
    }

    protected boolean uriMatchesScheme(Map<String, Object> serviceData) {
        if (this.uriSchemes == null) {
            return false;
        }
        String uri = this.getUriFromCredentials(this.getCredentials(serviceData));
        if (uri != null) {
            for (String uriScheme : this.uriSchemes) {
                if (!uri.startsWith(uriScheme + "://")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean uriKeyMatchesScheme(Map<String, Object> serviceData) {
        if (this.uriSchemes == null) {
            return false;
        }
        Map<String, Object> credentials = this.getCredentials(serviceData);
        for (String uriScheme : this.uriSchemes) {
            if (!credentials.containsKey(uriScheme + "Uri") && !credentials.containsKey(uriScheme + "uri") && !credentials.containsKey(uriScheme + "Url") && !credentials.containsKey(uriScheme + "url")) continue;
            return true;
        }
        return false;
    }

    protected String getId(Map<String, Object> serviceData) {
        return (String)serviceData.get("name");
    }

    protected Map<String, Object> getCredentials(Map<String, Object> serviceData) {
        return (Map)serviceData.get("credentials");
    }

    protected String getUriFromCredentials(Map<String, Object> credentials) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(Arrays.asList("uri", "url"));
        for (String uriScheme : this.uriSchemes) {
            keys.add(uriScheme + "Uri");
            keys.add(uriScheme + "uri");
            keys.add(uriScheme + "Url");
            keys.add(uriScheme + "url");
        }
        return this.getStringFromCredentials(credentials, keys.toArray(new String[keys.size()]));
    }

    protected String getStringFromCredentials(Map<String, Object> credentials, String ... keys) {
        if (credentials != null) {
            for (String key : keys) {
                if (!credentials.containsKey(key)) continue;
                return (String)credentials.get(key);
            }
        }
        return null;
    }

    protected int getIntFromCredentials(Map<String, Object> credentials, String ... keys) {
        if (credentials != null) {
            for (String key : keys) {
                if (!credentials.containsKey(key)) continue;
                return Integer.parseInt(credentials.get(key).toString());
            }
        }
        return -1;
    }

    public String[] getUriSchemes() {
        return this.uriSchemes;
    }

    public String getDefaultUriScheme() {
        return this.uriSchemes[0];
    }
}

