/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io;

import java.util.Arrays;

public final class CharTypes {
    private static final char[] HEX_CHARS;
    private static final byte[] HEX_BYTES;
    static final int[] sInputCodes;
    static final int[] sInputCodesUTF8;
    static final int[] sInputCodesJsNames;
    static final int[] sInputCodesUtf8JsNames;
    static final int[] sInputCodesComment;
    static final int[] sInputCodesWS;
    static final int[] sOutputEscapes128;
    static final int[] sHexValues;

    public static int[] getInputCodeLatin1() {
        return sInputCodes;
    }

    public static int[] getInputCodeUtf8() {
        return sInputCodesUTF8;
    }

    public static int[] getInputCodeLatin1JsNames() {
        return sInputCodesJsNames;
    }

    public static int[] getInputCodeUtf8JsNames() {
        return sInputCodesUtf8JsNames;
    }

    public static int[] getInputCodeComment() {
        return sInputCodesComment;
    }

    public static int[] getInputCodeWS() {
        return sInputCodesWS;
    }

    public static int[] get7BitOutputEscapes() {
        return sOutputEscapes128;
    }

    public static int charToHex(int n) {
        return n > 127 ? -1 : sHexValues[n];
    }

    public static void appendQuoted(StringBuilder stringBuilder, String string) {
        int[] nArray = sOutputEscapes128;
        int n = nArray.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= n || nArray[c] == 0) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('\\');
            int n3 = nArray[c];
            if (n3 < 0) {
                stringBuilder.append('u');
                stringBuilder.append('0');
                stringBuilder.append('0');
                char c2 = c;
                stringBuilder.append(HEX_CHARS[c2 >> 4]);
                stringBuilder.append(HEX_CHARS[c2 & 0xF]);
                continue;
            }
            stringBuilder.append((char)n3);
        }
    }

    public static char[] copyHexChars() {
        return (char[])HEX_CHARS.clone();
    }

    public static byte[] copyHexBytes() {
        return (byte[])HEX_BYTES.clone();
    }

    static {
        int n;
        int n2;
        HEX_CHARS = "0123456789ABCDEF".toCharArray();
        int n3 = HEX_CHARS.length;
        HEX_BYTES = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            CharTypes.HEX_BYTES[n2] = (byte)HEX_CHARS[n2];
        }
        int[] nArray = new int[256];
        for (n2 = 0; n2 < 32; ++n2) {
            nArray[n2] = -1;
        }
        nArray[34] = 1;
        nArray[92] = 1;
        sInputCodes = nArray;
        nArray = new int[sInputCodes.length];
        System.arraycopy(sInputCodes, 0, nArray, 0, nArray.length);
        for (n2 = 128; n2 < 256; ++n2) {
            int n4 = (n2 & 0xE0) == 192 ? 2 : ((n2 & 0xF0) == 224 ? 3 : ((n2 & 0xF8) == 240 ? 4 : -1));
            nArray[n2] = n4;
        }
        sInputCodesUTF8 = nArray;
        nArray = new int[256];
        Arrays.fill(nArray, -1);
        for (n2 = 33; n2 < 256; ++n2) {
            if (!Character.isJavaIdentifierPart((char)n2)) continue;
            nArray[n2] = 0;
        }
        nArray[64] = 0;
        nArray[35] = 0;
        nArray[42] = 0;
        nArray[45] = 0;
        nArray[43] = 0;
        sInputCodesJsNames = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesJsNames, 0, nArray, 0, nArray.length);
        Arrays.fill(nArray, 128, 128, 0);
        sInputCodesUtf8JsNames = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesUTF8, 128, nArray, 128, 128);
        Arrays.fill(nArray, 0, 32, -1);
        nArray[9] = 0;
        nArray[10] = 10;
        nArray[13] = 13;
        nArray[42] = 42;
        sInputCodesComment = nArray;
        nArray = new int[256];
        System.arraycopy(sInputCodesUTF8, 128, nArray, 128, 128);
        Arrays.fill(nArray, 0, 32, -1);
        nArray[32] = 1;
        nArray[9] = 1;
        nArray[10] = 10;
        nArray[13] = 13;
        nArray[47] = 47;
        nArray[35] = 35;
        sInputCodesWS = nArray;
        nArray = new int[128];
        for (n2 = 0; n2 < 32; ++n2) {
            nArray[n2] = -1;
        }
        nArray[34] = 34;
        nArray[92] = 92;
        nArray[8] = 98;
        nArray[9] = 116;
        nArray[12] = 102;
        nArray[10] = 110;
        nArray[13] = 114;
        sOutputEscapes128 = nArray;
        sHexValues = new int[128];
        Arrays.fill(sHexValues, -1);
        for (n = 0; n < 10; ++n) {
            CharTypes.sHexValues[48 + n] = n;
        }
        for (n = 0; n < 6; ++n) {
            CharTypes.sHexValues[97 + n] = 10 + n;
            CharTypes.sHexValues[65 + n] = 10 + n;
        }
    }
}

