/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public class JavaTypeDeserializer
extends StdScalarDeserializer<JavaType> {
    private static final long serialVersionUID = 1L;
    public static final JavaTypeDeserializer instance = new JavaTypeDeserializer();

    public JavaTypeDeserializer() {
        super(JavaType.class);
    }

    @Override
    public JavaType deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (JavaType)this.getEmptyValue();
            }
            return deserializationContext.getTypeFactory().constructFromCanonical(string);
        }
        if (jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (JavaType)jsonParser.getEmbeddedObject();
        }
        throw deserializationContext.mappingException(this._valueClass);
    }
}

