/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JacksonInject;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonBackReference;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonFilter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonGetter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonIdentityInfo;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonIdentityReference;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonManagedReference;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonPropertyDescription;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonRawValue;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonRootName;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonSetter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonTypeId;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonTypeName;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonUnwrapped;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonView;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.Version;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonSerializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.KeyDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.PropertyName;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonTypeResolver;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JsonValueInstantiator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.NoClass;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.cfg.PackageVersion;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.Annotated;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.ser.std.RawSerializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.Converter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.NameTransformer;

public class JacksonAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Deprecated
    public boolean isHandled(Annotation annotation) {
        return false;
    }

    @Override
    public boolean isAnnotationBundle(Annotation annotation) {
        return annotation.annotationType().getAnnotation(JacksonAnnotationsInside.class) != null;
    }

    @Override
    public PropertyName findRootName(AnnotatedClass annotatedClass) {
        JsonRootName jsonRootName = annotatedClass.getAnnotation(JsonRootName.class);
        if (jsonRootName == null) {
            return null;
        }
        return new PropertyName(jsonRootName.value());
    }

    @Override
    public String[] findPropertiesToIgnore(Annotated annotated) {
        JsonIgnoreProperties jsonIgnoreProperties = annotated.getAnnotation(JsonIgnoreProperties.class);
        return jsonIgnoreProperties == null ? null : jsonIgnoreProperties.value();
    }

    @Override
    public Boolean findIgnoreUnknownProperties(AnnotatedClass annotatedClass) {
        JsonIgnoreProperties jsonIgnoreProperties = annotatedClass.getAnnotation(JsonIgnoreProperties.class);
        return jsonIgnoreProperties == null ? null : Boolean.valueOf(jsonIgnoreProperties.ignoreUnknown());
    }

    @Override
    public Boolean isIgnorableType(AnnotatedClass annotatedClass) {
        JsonIgnoreType jsonIgnoreType = annotatedClass.getAnnotation(JsonIgnoreType.class);
        return jsonIgnoreType == null ? null : Boolean.valueOf(jsonIgnoreType.value());
    }

    @Override
    @Deprecated
    public Object findFilterId(AnnotatedClass annotatedClass) {
        return this._findFilterId(annotatedClass);
    }

    @Override
    public Object findFilterId(Annotated annotated) {
        return this._findFilterId(annotated);
    }

    protected final Object _findFilterId(Annotated annotated) {
        String string;
        JsonFilter jsonFilter = annotated.getAnnotation(JsonFilter.class);
        if (jsonFilter != null && (string = jsonFilter.value()).length() > 0) {
            return string;
        }
        return null;
    }

    @Override
    public Object findNamingStrategy(AnnotatedClass annotatedClass) {
        JsonNaming jsonNaming = annotatedClass.getAnnotation(JsonNaming.class);
        return jsonNaming == null ? null : jsonNaming.value();
    }

    @Override
    public VisibilityChecker<?> findAutoDetectVisibility(AnnotatedClass annotatedClass, VisibilityChecker<?> visibilityChecker) {
        JsonAutoDetect jsonAutoDetect = annotatedClass.getAnnotation(JsonAutoDetect.class);
        return jsonAutoDetect == null ? visibilityChecker : visibilityChecker.with(jsonAutoDetect);
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType(AnnotatedMember annotatedMember) {
        JsonManagedReference jsonManagedReference = annotatedMember.getAnnotation(JsonManagedReference.class);
        if (jsonManagedReference != null) {
            return AnnotationIntrospector.ReferenceProperty.managed(jsonManagedReference.value());
        }
        JsonBackReference jsonBackReference = annotatedMember.getAnnotation(JsonBackReference.class);
        if (jsonBackReference != null) {
            return AnnotationIntrospector.ReferenceProperty.back(jsonBackReference.value());
        }
        return null;
    }

    @Override
    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember annotatedMember) {
        JsonUnwrapped jsonUnwrapped = annotatedMember.getAnnotation(JsonUnwrapped.class);
        if (jsonUnwrapped == null || !jsonUnwrapped.enabled()) {
            return null;
        }
        String string = jsonUnwrapped.prefix();
        String string2 = jsonUnwrapped.suffix();
        return NameTransformer.simpleTransformer(string, string2);
    }

    @Override
    public boolean hasIgnoreMarker(AnnotatedMember annotatedMember) {
        return this._isIgnorable(annotatedMember);
    }

    @Override
    public Boolean hasRequiredMarker(AnnotatedMember annotatedMember) {
        JsonProperty jsonProperty = annotatedMember.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.required();
        }
        return null;
    }

    @Override
    public Object findInjectableValueId(AnnotatedMember annotatedMember) {
        JacksonInject jacksonInject = annotatedMember.getAnnotation(JacksonInject.class);
        if (jacksonInject == null) {
            return null;
        }
        String string = jacksonInject.value();
        if (string.length() == 0) {
            if (!(annotatedMember instanceof AnnotatedMethod)) {
                return annotatedMember.getRawType().getName();
            }
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)annotatedMember;
            if (annotatedMethod.getParameterCount() == 0) {
                return annotatedMember.getRawType().getName();
            }
            return annotatedMethod.getRawParameterType(0).getName();
        }
        return string;
    }

    @Override
    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType) {
        return this._findTypeResolver(mapperConfig, annotatedClass, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (javaType.isContainerType()) {
            return null;
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public TypeResolverBuilder<?> findPropertyContentTypeResolver(MapperConfig<?> mapperConfig, AnnotatedMember annotatedMember, JavaType javaType) {
        if (!javaType.isContainerType()) {
            throw new IllegalArgumentException("Must call method with a container type (got " + javaType + ")");
        }
        return this._findTypeResolver(mapperConfig, annotatedMember, javaType);
    }

    @Override
    public List<NamedType> findSubtypes(Annotated annotated) {
        JsonSubTypes jsonSubTypes = annotated.getAnnotation(JsonSubTypes.class);
        if (jsonSubTypes == null) {
            return null;
        }
        JsonSubTypes.Type[] typeArray = jsonSubTypes.value();
        ArrayList<NamedType> arrayList = new ArrayList<NamedType>(typeArray.length);
        for (JsonSubTypes.Type type : typeArray) {
            arrayList.add(new NamedType(type.value(), type.name()));
        }
        return arrayList;
    }

    @Override
    public String findTypeName(AnnotatedClass annotatedClass) {
        JsonTypeName jsonTypeName = annotatedClass.getAnnotation(JsonTypeName.class);
        return jsonTypeName == null ? null : jsonTypeName.value();
    }

    @Override
    public Object findSerializer(Annotated annotated) {
        Object object;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (object = jsonSerialize.using()) != JsonSerializer.None.class) {
            return object;
        }
        object = annotated.getAnnotation(JsonRawValue.class);
        if (object != null && object.value()) {
            Class<?> clazz = annotated.getRawType();
            return new RawSerializer(clazz);
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findKeySerializer(Annotated annotated) {
        Class<? extends JsonSerializer<?>> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<? extends JsonSerializer<?>> findContentSerializer(Annotated annotated) {
        Class<? extends JsonSerializer<?>> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findNullSerializer(Annotated annotated) {
        Class<? extends JsonSerializer<?>> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.nullsUsing()) != JsonSerializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public JsonInclude.Include findSerializationInclusion(Annotated annotated, JsonInclude.Include include) {
        JsonInclude jsonInclude = annotated.getAnnotation(JsonInclude.class);
        if (jsonInclude != null) {
            return jsonInclude.value();
        }
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null) {
            JsonSerialize.Inclusion inclusion = jsonSerialize.include();
            switch (inclusion) {
                case ALWAYS: {
                    return JsonInclude.Include.ALWAYS;
                }
                case NON_NULL: {
                    return JsonInclude.Include.NON_NULL;
                }
                case NON_DEFAULT: {
                    return JsonInclude.Include.NON_DEFAULT;
                }
                case NON_EMPTY: {
                    return JsonInclude.Include.NON_EMPTY;
                }
            }
        }
        return include;
    }

    @Override
    public Class<?> findSerializationType(Annotated annotated) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findSerializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public JsonSerialize.Typing findSerializationTyping(Annotated annotated) {
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        return jsonSerialize == null ? null : jsonSerialize.typing();
    }

    @Override
    public Object findSerializationConverter(Annotated annotated) {
        Class<? extends Converter<?, ?>> clazz;
        JsonSerialize jsonSerialize = annotated.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.converter()) != Converter.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findSerializationContentConverter(AnnotatedMember annotatedMember) {
        Class<? extends Converter<?, ?>> clazz;
        JsonSerialize jsonSerialize = annotatedMember.getAnnotation(JsonSerialize.class);
        if (jsonSerialize != null && (clazz = jsonSerialize.contentConverter()) != Converter.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?>[] findViews(Annotated annotated) {
        JsonView jsonView = annotated.getAnnotation(JsonView.class);
        return jsonView == null ? null : jsonView.value();
    }

    @Override
    public Boolean isTypeId(AnnotatedMember annotatedMember) {
        return annotatedMember.hasAnnotation(JsonTypeId.class);
    }

    @Override
    public ObjectIdInfo findObjectIdInfo(Annotated annotated) {
        JsonIdentityInfo jsonIdentityInfo = annotated.getAnnotation(JsonIdentityInfo.class);
        if (jsonIdentityInfo == null || jsonIdentityInfo.generator() == ObjectIdGenerators.None.class) {
            return null;
        }
        PropertyName propertyName = new PropertyName(jsonIdentityInfo.property());
        return new ObjectIdInfo(propertyName, jsonIdentityInfo.scope(), jsonIdentityInfo.generator());
    }

    @Override
    public ObjectIdInfo findObjectReferenceInfo(Annotated annotated, ObjectIdInfo objectIdInfo) {
        JsonIdentityReference jsonIdentityReference = annotated.getAnnotation(JsonIdentityReference.class);
        if (jsonIdentityReference != null) {
            objectIdInfo = objectIdInfo.withAlwaysAsId(jsonIdentityReference.alwaysAsId());
        }
        return objectIdInfo;
    }

    @Override
    public JsonFormat.Value findFormat(Annotated annotated) {
        JsonFormat jsonFormat = annotated.getAnnotation(JsonFormat.class);
        return jsonFormat == null ? null : new JsonFormat.Value(jsonFormat);
    }

    @Override
    public String findPropertyDescription(Annotated annotated) {
        JsonPropertyDescription jsonPropertyDescription = annotated.getAnnotation(JsonPropertyDescription.class);
        return jsonPropertyDescription == null ? null : jsonPropertyDescription.value();
    }

    @Override
    public String[] findSerializationPropertyOrder(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : jsonPropertyOrder.value();
    }

    @Override
    public Boolean findSerializationSortAlphabetically(AnnotatedClass annotatedClass) {
        JsonPropertyOrder jsonPropertyOrder = annotatedClass.getAnnotation(JsonPropertyOrder.class);
        return jsonPropertyOrder == null ? null : Boolean.valueOf(jsonPropertyOrder.alphabetic());
    }

    @Override
    public PropertyName findNameForSerialization(Annotated annotated) {
        String string = annotated instanceof AnnotatedField ? this.findSerializationName((AnnotatedField)annotated) : (annotated instanceof AnnotatedMethod ? this.findSerializationName((AnnotatedMethod)annotated) : null);
        if (string != null) {
            if (string.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(string);
        }
        return null;
    }

    @Override
    @Deprecated
    public String findSerializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonSerialize.class) || annotatedField.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    @Deprecated
    public String findSerializationName(AnnotatedMethod annotatedMethod) {
        JsonGetter jsonGetter = annotatedMethod.getAnnotation(JsonGetter.class);
        if (jsonGetter != null) {
            return jsonGetter.value();
        }
        JsonProperty jsonProperty = annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonSerialize.class) || annotatedMethod.hasAnnotation(JsonView.class)) {
            return "";
        }
        return null;
    }

    @Override
    public boolean hasAsValueAnnotation(AnnotatedMethod annotatedMethod) {
        JsonValue jsonValue = annotatedMethod.getAnnotation(JsonValue.class);
        return jsonValue != null && jsonValue.value();
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer<?>> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.using()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<? extends KeyDeserializer> findKeyDeserializer(Annotated annotated) {
        Class<? extends KeyDeserializer> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyUsing()) != KeyDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<? extends JsonDeserializer<?>> findContentDeserializer(Annotated annotated) {
        Class<? extends JsonDeserializer<?>> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentUsing()) != JsonDeserializer.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.as()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationKeyType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.keyAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Class<?> findDeserializationContentType(Annotated annotated, JavaType javaType) {
        Class<?> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentAs()) != NoClass.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findDeserializationConverter(Annotated annotated) {
        Class<? extends Converter<?, ?>> clazz;
        JsonDeserialize jsonDeserialize = annotated.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.converter()) != Converter.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findDeserializationContentConverter(AnnotatedMember annotatedMember) {
        Class<? extends Converter<?, ?>> clazz;
        JsonDeserialize jsonDeserialize = annotatedMember.getAnnotation(JsonDeserialize.class);
        if (jsonDeserialize != null && (clazz = jsonDeserialize.contentConverter()) != Converter.None.class) {
            return clazz;
        }
        return null;
    }

    @Override
    public Object findValueInstantiator(AnnotatedClass annotatedClass) {
        JsonValueInstantiator jsonValueInstantiator = annotatedClass.getAnnotation(JsonValueInstantiator.class);
        return jsonValueInstantiator == null ? null : jsonValueInstantiator.value();
    }

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass annotatedClass) {
        JsonDeserialize jsonDeserialize = annotatedClass.getAnnotation(JsonDeserialize.class);
        return jsonDeserialize == null || jsonDeserialize.builder() == NoClass.class ? null : jsonDeserialize.builder();
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass annotatedClass) {
        JsonPOJOBuilder jsonPOJOBuilder = annotatedClass.getAnnotation(JsonPOJOBuilder.class);
        return jsonPOJOBuilder == null ? null : new JsonPOJOBuilder.Value(jsonPOJOBuilder);
    }

    @Override
    public PropertyName findNameForDeserialization(Annotated annotated) {
        String string = annotated instanceof AnnotatedField ? this.findDeserializationName((AnnotatedField)annotated) : (annotated instanceof AnnotatedMethod ? this.findDeserializationName((AnnotatedMethod)annotated) : (annotated instanceof AnnotatedParameter ? this.findDeserializationName((AnnotatedParameter)annotated) : null));
        if (string != null) {
            if (string.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(string);
        }
        return null;
    }

    @Override
    @Deprecated
    public String findDeserializationName(AnnotatedMethod annotatedMethod) {
        JsonSetter jsonSetter = annotatedMethod.getAnnotation(JsonSetter.class);
        if (jsonSetter != null) {
            return jsonSetter.value();
        }
        JsonProperty jsonProperty = annotatedMethod.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedMethod.hasAnnotation(JsonDeserialize.class) || annotatedMethod.hasAnnotation(JsonView.class) || annotatedMethod.hasAnnotation(JsonBackReference.class) || annotatedMethod.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    @Deprecated
    public String findDeserializationName(AnnotatedField annotatedField) {
        JsonProperty jsonProperty = annotatedField.getAnnotation(JsonProperty.class);
        if (jsonProperty != null) {
            return jsonProperty.value();
        }
        if (annotatedField.hasAnnotation(JsonDeserialize.class) || annotatedField.hasAnnotation(JsonView.class) || annotatedField.hasAnnotation(JsonBackReference.class) || annotatedField.hasAnnotation(JsonManagedReference.class)) {
            return "";
        }
        return null;
    }

    @Override
    @Deprecated
    public String findDeserializationName(AnnotatedParameter annotatedParameter) {
        JsonProperty jsonProperty;
        if (annotatedParameter != null && (jsonProperty = annotatedParameter.getAnnotation(JsonProperty.class)) != null) {
            return jsonProperty.value();
        }
        return null;
    }

    @Override
    public boolean hasAnySetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnySetter.class);
    }

    @Override
    public boolean hasAnyGetterAnnotation(AnnotatedMethod annotatedMethod) {
        return annotatedMethod.hasAnnotation(JsonAnyGetter.class);
    }

    @Override
    public boolean hasCreatorAnnotation(Annotated annotated) {
        return annotated.hasAnnotation(JsonCreator.class);
    }

    protected boolean _isIgnorable(Annotated annotated) {
        JsonIgnore jsonIgnore = annotated.getAnnotation(JsonIgnore.class);
        return jsonIgnore != null && jsonIgnore.value();
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> mapperConfig, Annotated annotated, JavaType javaType) {
        TypeIdResolver typeIdResolver;
        StdTypeResolverBuilder stdTypeResolverBuilder;
        JsonTypeInfo jsonTypeInfo = annotated.getAnnotation(JsonTypeInfo.class);
        JsonTypeResolver jsonTypeResolver = annotated.getAnnotation(JsonTypeResolver.class);
        if (jsonTypeResolver != null) {
            if (jsonTypeInfo == null) {
                return null;
            }
            stdTypeResolverBuilder = mapperConfig.typeResolverBuilderInstance(annotated, jsonTypeResolver.value());
        } else {
            if (jsonTypeInfo == null) {
                return null;
            }
            if (jsonTypeInfo.use() == JsonTypeInfo.Id.NONE) {
                return this._constructNoTypeResolverBuilder();
            }
            stdTypeResolverBuilder = this._constructStdTypeResolverBuilder();
        }
        JsonTypeIdResolver jsonTypeIdResolver = annotated.getAnnotation(JsonTypeIdResolver.class);
        TypeIdResolver typeIdResolver2 = typeIdResolver = jsonTypeIdResolver == null ? null : mapperConfig.typeIdResolverInstance(annotated, jsonTypeIdResolver.value());
        if (typeIdResolver != null) {
            typeIdResolver.init(javaType);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.init(jsonTypeInfo.use(), typeIdResolver);
        JsonTypeInfo.As as = jsonTypeInfo.include();
        if (as == JsonTypeInfo.As.EXTERNAL_PROPERTY && annotated instanceof AnnotatedClass) {
            as = JsonTypeInfo.As.PROPERTY;
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.inclusion(as);
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeProperty(jsonTypeInfo.property());
        Class<?> clazz = jsonTypeInfo.defaultImpl();
        if (clazz != JsonTypeInfo.None.class) {
            stdTypeResolverBuilder = stdTypeResolverBuilder.defaultImpl(clazz);
        }
        stdTypeResolverBuilder = stdTypeResolverBuilder.typeIdVisibility(jsonTypeInfo.visible());
        return stdTypeResolverBuilder;
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new StdTypeResolverBuilder();
    }

    protected StdTypeResolverBuilder _constructNoTypeResolverBuilder() {
        return StdTypeResolverBuilder.noTypeInfoBuilder();
    }
}

