/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.impl;

import java.util.Collection;
import java.util.HashMap;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.BeanDescription;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DatabindContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JavaType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final HashMap<String, String> _typeToId;
    protected final HashMap<String, JavaType> _idToType;

    protected TypeNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType, HashMap<String, String> hashMap, HashMap<String, JavaType> hashMap2) {
        super(javaType, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = hashMap;
        this._idToType = hashMap2;
    }

    public static TypeNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (bl == bl2) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> hashMap = null;
        HashMap<String, JavaType> hashMap2 = null;
        if (bl) {
            hashMap = new HashMap<String, String>();
        }
        if (bl2) {
            hashMap2 = new HashMap<String, JavaType>();
        }
        if (collection != null) {
            for (NamedType namedType : collection) {
                JavaType javaType2;
                String string;
                Class<?> clazz = namedType.getType();
                String string2 = string = namedType.hasName() ? namedType.getName() : TypeNameIdResolver._defaultTypeId(clazz);
                if (bl) {
                    hashMap.put(clazz.getName(), string);
                }
                if (!bl2 || (javaType2 = hashMap2.get(string)) != null && clazz.isAssignableFrom(javaType2.getRawClass())) continue;
                hashMap2.put(string, mapperConfig.constructType(clazz));
            }
        }
        return new TypeNameIdResolver(mapperConfig, javaType, hashMap, hashMap2);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String idFromValue(Object object) {
        String string;
        Class<?> clazz = this._typeFactory.constructType(object.getClass()).getRawClass();
        String string2 = clazz.getName();
        HashMap<String, String> hashMap = this._typeToId;
        synchronized (hashMap) {
            string = this._typeToId.get(string2);
            if (string == null) {
                if (this._config.isAnnotationProcessingEnabled()) {
                    BeanDescription beanDescription = this._config.introspectClassAnnotations(clazz);
                    string = this._config.getAnnotationIntrospector().findTypeName(beanDescription.getClassInfo());
                }
                if (string == null) {
                    string = TypeNameIdResolver._defaultTypeId(clazz);
                }
                this._typeToId.put(string2, string);
            }
        }
        return string;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        if (object == null) {
            return null;
        }
        return this.idFromValue(object);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String string) {
        return this._typeFromId(string);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string);
    }

    protected JavaType _typeFromId(String string) {
        return this._idToType.get(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; id-to-type=").append(this._idToType);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected static String _defaultTypeId(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }
}

