/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationSummary;
import org.cloudfoundry.operations.applications.InstanceDetail;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;

public class CloudFoundryDiscoveryClient
implements DiscoveryClient {
    private final CloudFoundryService cloudFoundryService;
    private final CloudFoundryOperations cloudFoundryOperations;
    private final CloudFoundryDiscoveryProperties properties;
    private final String description = "Cloud Foundry " + DiscoveryClient.class.getName() + " implementation";

    CloudFoundryDiscoveryClient(CloudFoundryOperations cloudFoundryOperations, CloudFoundryService svc, CloudFoundryDiscoveryProperties properties) {
        this.cloudFoundryService = svc;
        this.cloudFoundryOperations = cloudFoundryOperations;
        this.properties = properties;
    }

    public String description() {
        return this.description;
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        return this.cloudFoundryService.getApplicationInstances(serviceId).map(tuple -> {
            ApplicationDetail applicationDetail = (ApplicationDetail)tuple.getT1();
            InstanceDetail instanceDetail = (InstanceDetail)tuple.getT2();
            String applicationId = applicationDetail.getId();
            String applicationIndex = instanceDetail.getIndex();
            String instanceId = applicationId + "." + applicationIndex;
            String name = applicationDetail.getName();
            String url = applicationDetail.getUrls().size() > 0 ? (String)applicationDetail.getUrls().get(0) : null;
            boolean secure = (url + "").toLowerCase().startsWith("https");
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("applicationId", applicationId);
            metadata.put("instanceId", applicationIndex);
            return new DefaultServiceInstance(instanceId, name, url, secure ? 443 : 80, secure, metadata);
        }).collectList().blockOptional().orElse(new ArrayList());
    }

    public List<String> getServices() {
        return this.cloudFoundryOperations.applications().list().map(ApplicationSummary::getName).collectList().blockOptional().orElse(new ArrayList());
    }

    public int getOrder() {
        return this.properties.getOrder();
    }

    CloudFoundryService getCloudFoundryService() {
        return this.cloudFoundryService;
    }
}

