/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.common.security.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.common.security.AuthorizationProperties;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SecurityConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecurityConfigUtils.class);
    public static final String ROLE_PREFIX = "ROLE_";
    public static final Pattern AUTHORIZATION_RULE;

    public static ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry configureSimpleSecurity(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry security, AuthorizationProperties authorizationProperties) {
        for (String rule : authorizationProperties.getRules()) {
            Matcher matcher = AUTHORIZATION_RULE.matcher(rule);
            Assert.isTrue((boolean)matcher.matches(), (String)String.format("Unable to parse security rule [%s], expected format is 'HTTP_METHOD ANT_PATTERN => SECURITY_ATTRIBUTE(S)'", rule));
            HttpMethod method = HttpMethod.valueOf((String)matcher.group(1).trim());
            String urlPattern = matcher.group(2).trim();
            String attribute = matcher.group(3).trim();
            logger.info("Authorization '{}' | '{}' | '{}'", new Object[]{method, attribute, urlPattern});
            security = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)security.antMatchers(method, new String[]{urlPattern})).access(attribute);
        }
        return security;
    }

    static {
        String methodsRegex = StringUtils.arrayToDelimitedString((Object[])HttpMethod.values(), (String)"|");
        AUTHORIZATION_RULE = Pattern.compile("(" + methodsRegex + ")\\s+(.+)\\s+=>\\s+(.+)");
    }
}

