/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.hypermedia.ServiceInstanceProvider;

public class DynamicServiceInstanceProvider
implements ServiceInstanceProvider {
    private final DiscoveryClient client;
    private final String serviceName;

    @Override
    public ServiceInstance getServiceInstance() {
        try {
            List<ServiceInstance> instances = this.client.getInstances(this.serviceName);
            return instances.isEmpty() ? null : instances.get(0);
        }
        catch (RuntimeException o_O) {
            return null;
        }
    }

    @ConstructorProperties(value={"client", "serviceName"})
    public DynamicServiceInstanceProvider(DiscoveryClient client, String serviceName) {
        this.client = client;
        this.serviceName = serviceName;
    }
}

