/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureBefore(value={NoopDiscoveryClientAutoConfiguration.class})
public class SimpleDiscoveryClientAutoConfiguration
implements ApplicationListener<WebServerInitializedEvent> {
    @Autowired(required=false)
    private ServerProperties server;
    @Autowired
    private ApplicationContext context;
    @Value(value="${spring.application.name:application}")
    private String serviceId;
    @Autowired
    private InetUtils inet;
    private int port = 0;
    private SimpleDiscoveryProperties simple = new SimpleDiscoveryProperties();

    @Bean
    public SimpleDiscoveryProperties simpleDiscoveryProperties() {
        this.simple.getLocal().setServiceId(this.serviceId);
        this.simple.getLocal().setUri(URI.create("http://" + this.inet.findFirstNonLoopbackHostInfo().getHostname() + ":" + this.findPort()));
        return this.simple;
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public DiscoveryClient simpleDiscoveryClient() {
        return new SimpleDiscoveryClient(this.simpleDiscoveryProperties());
    }

    private int findPort() {
        if (this.port > 0) {
            return this.port;
        }
        if (this.server != null && this.server.getPort() != null && this.server.getPort() > 0) {
            return this.server.getPort();
        }
        return 8080;
    }

    public void onApplicationEvent(WebServerInitializedEvent webServerInitializedEvent) {
        this.port = webServerInitializedEvent.getWebServer().getPort();
        if (this.port > 0) {
            this.simple.getLocal().setUri(URI.create("http://" + this.inet.findFirstNonLoopbackHostInfo().getHostname() + ":" + this.port));
        }
    }
}

