/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.cloud.client.hypermedia.RemoteResourceRefresher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(type={"org.springframework.cloud.client.hypermedia.RemoteResource"})
@EnableConfigurationProperties(value={CloudHypermediaProperties.class})
public class CloudHypermediaAutoConfiguration {
    @Autowired(required=false)
    List<RemoteResource> discoveredResources = Collections.emptyList();
    @Autowired
    CloudHypermediaProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public RemoteResourceRefresher discoveredResourceRefresher() {
        return new RemoteResourceRefresher(this.discoveredResources, this.properties.getRefresh().getFixedDelay(), this.properties.getRefresh().getInitialDelay());
    }

    @ConfigurationProperties(prefix="spring.cloud.hypermedia")
    public static class CloudHypermediaProperties {
        private Refresh refresh = new Refresh();

        public Refresh getRefresh() {
            return this.refresh;
        }

        public void setRefresh(Refresh refresh) {
            this.refresh = refresh;
        }

        public static class Refresh {
            private int fixedDelay = 5000;
            private int initialDelay = 10000;

            public int getFixedDelay() {
                return this.fixedDelay;
            }

            public void setFixedDelay(int fixedDelay) {
                this.fixedDelay = fixedDelay;
            }

            public int getInitialDelay() {
                return this.initialDelay;
            }

            public void setInitialDelay(int initialDelay) {
                this.initialDelay = initialDelay;
            }
        }
    }
}

