/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.loadbalancer.SimpleObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestClient;

public class LoadBalancerRestClientBuilderBeanPostProcessor<T extends ClientHttpRequestInterceptor>
implements BeanPostProcessor {
    private final ObjectProvider<T> loadBalancerInterceptorProvider;
    private final ApplicationContext context;

    public LoadBalancerRestClientBuilderBeanPostProcessor(T loadBalancerInterceptor, ApplicationContext context) {
        this.loadBalancerInterceptorProvider = new SimpleObjectProvider<T>(loadBalancerInterceptor);
        this.context = context;
    }

    public LoadBalancerRestClientBuilderBeanPostProcessor(ObjectProvider<T> loadBalancerInterceptorProvider, ApplicationContext context) {
        this.loadBalancerInterceptorProvider = loadBalancerInterceptorProvider;
        this.context = context;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RestClient.Builder) {
            if (this.context.findAnnotationOnBean(beanName, LoadBalanced.class) == null) {
                return bean;
            }
            ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)this.loadBalancerInterceptorProvider.getIfAvailable();
            if (interceptor == null) {
                throw new IllegalStateException(ClientHttpRequestInterceptor.class.getSimpleName() + " not available.");
            }
            ((RestClient.Builder)bean).requestInterceptor(interceptor);
        }
        return bean;
    }
}

