/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.hypermedia;

import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.hypermedia.RemoteResource;
import org.springframework.cloud.client.hypermedia.ServiceInstanceProvider;
import org.springframework.cloud.client.hypermedia.TraversalDefinition;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.client.Traverson;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class DiscoveredResource
implements RemoteResource {
    private final ServiceInstanceProvider provider;
    private final TraversalDefinition traversal;
    private final Logger log = LoggerFactory.getLogger(DiscoveredResource.class);
    private RestOperations restOperations = new RestTemplate();
    private Link link = null;

    public DiscoveredResource(ServiceInstanceProvider provider, TraversalDefinition traversal) {
        this.provider = provider;
        this.traversal = traversal;
    }

    public ServiceInstanceProvider getProvider() {
        return this.provider;
    }

    public TraversalDefinition getTraversal() {
        return this.traversal;
    }

    public RestOperations getRestOperations() {
        return this.restOperations;
    }

    public void setRestOperations(RestOperations restOperations) {
        this.restOperations = restOperations == null ? new RestTemplate() : restOperations;
    }

    @Override
    public Link getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.link = link;
    }

    @Override
    public void verifyOrDiscover() {
        this.link = this.link == null ? this.discoverLink() : this.verify(this.link);
    }

    private Link verify(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        try {
            String uri = link.expand(new Object[0]).getHref();
            this.log.debug("Verifying link pointing to {}...", (Object)uri);
            this.restOperations.headForHeaders(uri, new Object[0]);
            this.log.debug("Successfully verified link!");
            return link;
        }
        catch (RestClientException e) {
            this.log.debug("Verification failed, marking as outdated!");
            return null;
        }
    }

    private Link discoverLink() {
        try {
            ServiceInstance service = this.provider.getServiceInstance();
            if (service == null) {
                return null;
            }
            URI uri = service.getUri();
            String serviceId = service.getServiceId();
            this.log.debug("Discovered {} system at {}. Discovering resource...", (Object)serviceId, (Object)uri);
            Traverson traverson = new Traverson(uri, new MediaType[]{MediaTypes.HAL_JSON});
            Link link = this.traversal.buildTraversal(traverson).asTemplatedLink();
            this.log.debug("Found link pointing to {}.", (Object)link.getHref());
            return link;
        }
        catch (RuntimeException exception) {
            this.link = null;
            this.log.debug("Target system unavailable. Got: ", (Object)exception.getMessage());
            return null;
        }
    }
}

