/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.logging;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class LoggingRebinder
implements ApplicationListener<EnvironmentChangeEvent>,
EnvironmentAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.environment == null) {
            return;
        }
        LoggingSystem system = LoggingSystem.get((ClassLoader)LoggingSystem.class.getClassLoader());
        this.setLogLevels(system, this.environment);
    }

    protected void setLogLevels(LoggingSystem system, Environment environment) {
        Map levels = new RelaxedPropertyResolver((PropertyResolver)environment).getSubProperties("logging.level.");
        for (Map.Entry entry : levels.entrySet()) {
            this.setLogLevel(system, environment, (String)entry.getKey(), entry.getValue().toString());
        }
    }

    private void setLogLevel(LoggingSystem system, Environment environment, String name, String level) {
        try {
            if (name.equalsIgnoreCase("root")) {
                name = null;
            }
            level = environment.resolvePlaceholders(level);
            system.setLogLevel(name, LogLevel.valueOf((String)level));
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)("Cannot set level: " + level + " for '" + name + "'"));
        }
    }
}

