/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

public final class ConfigClientStateHolder {
    private static ThreadLocal<String> state = new ThreadLocal();

    private ConfigClientStateHolder() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static void resetState() {
        state.remove();
    }

    public static String getState() {
        return state.get();
    }

    public static void setState(String newState) {
        if (newState == null) {
            ConfigClientStateHolder.resetState();
            return;
        }
        state.set(newState);
    }
}

