/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.ssh.HostKeyAlgoSupported;
import org.springframework.cloud.config.server.ssh.HostKeyAndAlgoBothExist;
import org.springframework.cloud.config.server.ssh.PrivateKeyIsValid;
import org.springframework.cloud.config.server.ssh.SshUri;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.config.server.git")
@Validated
@PrivateKeyIsValid
@HostKeyAndAlgoBothExist
@HostKeyAlgoSupported
public class SshUriProperties
extends SshUri {
    private Map<String, SshUriNestedRepoProperties> repos = new LinkedHashMap<String, SshUriNestedRepoProperties>();

    public Map<String, SshUriNestedRepoProperties> getRepos() {
        return this.repos;
    }

    public void setRepos(Map<String, SshUriNestedRepoProperties> repos) {
        this.repos = repos;
    }

    public void addRepo(String repoName, SshUriNestedRepoProperties properties) {
        this.repos.put(repoName, properties);
    }

    @Override
    public String toString() {
        return super.toString() + "{repos=" + this.repos + "}";
    }

    public static class SshUriNestedRepoProperties
    extends SshUri {
    }
}

