/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerHealthIndicator;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.ConsulEnvironmentWatch;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.VaultEnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.web.client.RestTemplate;

@Configuration
public class EnvironmentRepositoryConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.cloud.config.server.health.enabled"}, matchIfMissing=true)
    public ConfigServerHealthIndicator configServerHealthIndicator(EnvironmentRepository repository) {
        return new ConfigServerHealthIndicator(repository);
    }

    @Configuration
    @ConditionalOnMissingBean(value={EnvironmentWatch.class})
    protected static class DefaultEnvironmentWatch {
        protected DefaultEnvironmentWatch() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new EnvironmentWatch.Default();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"spring.cloud.config.server.consul.watch.enabled"})
    protected static class ConsulEnvironmentWatchConfiguration {
        protected ConsulEnvironmentWatchConfiguration() {
        }

        @Bean
        public EnvironmentWatch environmentWatch() {
            return new ConsulEnvironmentWatch();
        }
    }

    @Configuration
    @Profile(value={"vault"})
    protected static class VaultConfiguration {
        protected VaultConfiguration() {
        }

        @Bean
        public VaultEnvironmentRepository vaultEnvironmentRepository(HttpServletRequest request, EnvironmentWatch watch) {
            return new VaultEnvironmentRepository(request, watch, new RestTemplate());
        }
    }

    @Configuration
    @Profile(value={"subversion"})
    protected static class SvnRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;
        @Autowired
        private ConfigServerProperties server;

        protected SvnRepositoryConfiguration() {
        }

        @Bean
        public SvnKitEnvironmentRepository svnKitEnvironmentRepository() {
            SvnKitEnvironmentRepository repository = new SvnKitEnvironmentRepository(this.environment);
            if (this.server.getDefaultLabel() != null) {
                repository.setDefaultLabel(this.server.getDefaultLabel());
            }
            return repository;
        }
    }

    @Configuration
    @Profile(value={"git"})
    protected static class GitRepositoryConfiguration
    extends DefaultRepositoryConfiguration {
        protected GitRepositoryConfiguration() {
        }
    }

    @Configuration
    @Profile(value={"native"})
    protected static class NativeRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;

        protected NativeRepositoryConfiguration() {
        }

        @Bean
        public NativeEnvironmentRepository nativeEnvironmentRepository() {
            return new NativeEnvironmentRepository(this.environment);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={EnvironmentRepository.class})
    protected static class DefaultRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;
        @Autowired
        private ConfigServerProperties server;
        @Autowired(required=false)
        private TransportConfigCallback transportConfigCallback;

        protected DefaultRepositoryConfiguration() {
        }

        @Bean
        public MultipleJGitEnvironmentRepository defaultEnvironmentRepository() {
            MultipleJGitEnvironmentRepository repository = new MultipleJGitEnvironmentRepository(this.environment);
            repository.setTransportConfigCallback(this.transportConfigCallback);
            if (this.server.getDefaultLabel() != null) {
                repository.setDefaultLabel(this.server.getDefaultLabel());
            }
            return repository;
        }
    }
}

