/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.File;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.config.server.ssh.KnownHostsFileIsValid;
import org.springframework.cloud.config.server.ssh.SshUriProperties;

public class KnownHostsFileValidator
implements ConstraintValidator<KnownHostsFileIsValid, SshUriProperties> {
    public void initialize(KnownHostsFileIsValid knownHostsFileIsValid) {
    }

    public boolean isValid(SshUriProperties sshUriProperties, ConstraintValidatorContext context) {
        String knownHostsFile = sshUriProperties.getKnownHostsFile();
        if (knownHostsFile != null && !new File(knownHostsFile).exists()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(String.format("File '%s' specified in property 'spring.cloud.config.server.git.knownHostsFile' could not be located", knownHostsFile)).addConstraintViolation();
            return false;
        }
        return true;
    }
}

