/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.PropertiesResultSetExtractor;
import org.springframework.core.Ordered;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.config.server.jdbc")
public class JdbcEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final String DEFAULT_SQL = "SELECT KEY, VALUE from PROPERTIES where APPLICATION=? and PROFILE=? and LABEL=?";
    private int order = 0x7FFFFFF5;
    private final JdbcTemplate jdbc;
    private String sql = "SELECT KEY, VALUE from PROPERTIES where APPLICATION=? and PROFILE=? and LABEL=?";
    private final PropertiesResultSetExtractor extractor = new PropertiesResultSetExtractor();

    public JdbcEnvironmentRepository(JdbcTemplate jdbc) {
        this.jdbc = jdbc;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String config = application;
        if (StringUtils.isEmpty((Object)label)) {
            label = "master";
        }
        if (StringUtils.isEmpty((Object)profile)) {
            profile = "default";
        }
        if (!profile.startsWith("default")) {
            profile = "default," + profile;
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profiles, label, null, null);
        if (!config.startsWith("application")) {
            config = "application," + config;
        }
        ArrayList<String> applications = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)config))));
        ArrayList<String> envs = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(profiles)));
        Collections.reverse(applications);
        Collections.reverse(envs);
        for (String app : applications) {
            for (String env : envs) {
                Map next = (Map)this.jdbc.query(this.sql, new Object[]{app, env, label}, (ResultSetExtractor)this.extractor);
                if (next.isEmpty()) continue;
                environment.add(new PropertySource(app + "-" + env, next));
            }
        }
        return environment;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

