/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.encryption;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

class EnvironmentPrefixHelper {
    private static final String PROFILES = "profiles";
    private static final String NAME = "name";
    private static final String ESCAPE = "{plain}";

    EnvironmentPrefixHelper() {
    }

    public Map<String, String> getEncryptorKeys(String name, String profiles, String text) {
        LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
        text = this.removeEnvironmentPrefix(text);
        keys.put(NAME, name);
        keys.put(PROFILES, profiles);
        if (text.contains(ESCAPE)) {
            text = text.substring(0, text.indexOf(ESCAPE));
        }
        String[] tokens = StringUtils.split((String)text, (String)"}");
        while (tokens != null) {
            String token = tokens[0].trim();
            if (token.startsWith("{")) {
                String key = "";
                String value = "";
                if (token.contains(":") && !token.endsWith(":")) {
                    key = token.substring(1, token.indexOf(":"));
                    value = token.substring(token.indexOf(":") + 1);
                } else {
                    key = token.substring(1);
                }
                keys.put(key, value);
            }
            text = tokens[1];
            tokens = StringUtils.split((String)text, (String)"}");
        }
        return keys;
    }

    public String addPrefix(Map<String, String> keys, String input) {
        keys.remove(NAME);
        keys.remove(PROFILES);
        StringBuilder builder = new StringBuilder();
        for (String key : keys.keySet()) {
            builder.append("{").append(key).append(":").append(keys.get(key)).append("}");
        }
        builder.append(input);
        return builder.toString();
    }

    public String stripPrefix(String value) {
        if (!value.contains("}")) {
            return value;
        }
        if (value.contains(ESCAPE)) {
            return value.substring(value.indexOf(ESCAPE) + ESCAPE.length());
        }
        return value.replaceFirst("^(\\{.*?:.*?\\})+", "");
    }

    private String removeEnvironmentPrefix(String input) {
        return input.replaceFirst("\\{name:.*\\}", "").replaceFirst("\\{profiles:.*\\}", "");
    }
}

