/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategyFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Validated
public class VaultEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    public static final String VAULT_TOKEN = "X-Vault-Token";
    public static final String VAULT_NAMESPACE = "X-Vault-Namespace";
    @NotEmpty
    private String host;
    @Min(value=1L)
    @Max(value=65535L)
    private @Min(value=1L) @Max(value=65535L) int port;
    private String scheme;
    @NotEmpty
    private String backend;
    private String defaultKey;
    private String namespace;
    @NotEmpty
    private String profileSeparator;
    private int order;
    private VaultKvAccessStrategy accessStrategy;
    private ObjectProvider<HttpServletRequest> request;
    private EnvironmentWatch watch;

    public VaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, RestTemplate rest, VaultEnvironmentProperties properties) {
        this.request = request;
        this.watch = watch;
        this.backend = properties.getBackend();
        this.defaultKey = properties.getDefaultKey();
        this.host = properties.getHost();
        this.order = properties.getOrder();
        this.port = properties.getPort();
        this.profileSeparator = properties.getProfileSeparator();
        this.scheme = properties.getScheme();
        this.namespace = properties.getNamespace();
        String baseUrl = String.format("%s://%s:%s", this.scheme, this.host, this.port);
        this.accessStrategy = VaultKvAccessStrategyFactory.forVersion((RestOperations)rest, baseUrl, properties.getKvVersion());
    }

    void setAccessStrategy(VaultKvAccessStrategy accessStrategy) {
        this.accessStrategy = accessStrategy;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        HttpServletRequest servletRequest = (HttpServletRequest)this.request.getIfAvailable();
        if (servletRequest == null) {
            throw new IllegalStateException("No HttpServletRequest available");
        }
        String state = servletRequest.getHeader("X-Config-State");
        String newState = this.watch.watch(state);
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        List<String> scrubbedProfiles = this.scrubProfiles(profiles);
        List<String> keys = this.findKeys(application, scrubbedProfiles);
        Environment environment = new Environment(application, profiles, label, null, newState);
        for (String key : keys) {
            String data = this.read(servletRequest, key);
            if (data == null) continue;
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            yaml.setResources(new Resource[]{new ByteArrayResource(data.getBytes())});
            Properties properties = yaml.getObject();
            if (properties.isEmpty()) continue;
            environment.add(new PropertySource("vault:" + key, (Map)properties));
        }
        return environment;
    }

    private List<String> findKeys(String application, List<String> profiles) {
        ArrayList<String> keys = new ArrayList<String>();
        if (StringUtils.hasText((String)this.defaultKey) && !this.defaultKey.equals(application)) {
            keys.add(this.defaultKey);
            this.addProfiles(keys, this.defaultKey, profiles);
        }
        keys.add(application);
        this.addProfiles(keys, application, profiles);
        Collections.reverse(keys);
        return keys;
    }

    private List<String> scrubProfiles(String[] profiles) {
        ArrayList<String> scrubbedProfiles = new ArrayList<String>(Arrays.asList(profiles));
        if (scrubbedProfiles.contains("default")) {
            scrubbedProfiles.remove("default");
        }
        return scrubbedProfiles;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.profileSeparator + profile);
        }
    }

    String read(HttpServletRequest servletRequest, String key) {
        HttpHeaders headers = new HttpHeaders();
        String token = servletRequest.getHeader("X-Config-Token");
        if (!StringUtils.hasLength((String)token)) {
            throw new IllegalArgumentException("Missing required header: X-Config-Token");
        }
        headers.add(VAULT_TOKEN, token);
        if (StringUtils.hasText((String)this.namespace)) {
            headers.add(VAULT_NAMESPACE, this.namespace);
        }
        return this.accessStrategy.getData(headers, this.backend, key);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setDefaultKey(String defaultKey) {
        this.defaultKey = defaultKey;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

