/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.cloud.config.server.encryption.CipherResourceJsonEncryptor;
import org.springframework.cloud.config.server.encryption.CipherResourcePropertiesEncryptor;
import org.springframework.cloud.config.server.encryption.CipherResourceYamlEncryptor;
import org.springframework.cloud.config.server.encryption.ResourceEncryptor;
import org.springframework.cloud.config.server.encryption.TextEncryptorLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="${spring.cloud.config.server.encrypt.enabled:true} && ${spring.cloud.config.server.encrypt.plainTextEncrypt:true}")
@ConditionalOnBean(value={TextEncryptorLocator.class})
public class ResourceEncryptorConfiguration {
    @Autowired
    private TextEncryptorLocator encryptor;

    @Bean
    Map<String, ResourceEncryptor> resourceEncryptors() {
        HashMap<String, ResourceEncryptor> resourceEncryptorMap = new HashMap<String, ResourceEncryptor>();
        this.addSupportedExtensionsToMap(resourceEncryptorMap, new CipherResourceJsonEncryptor(this.encryptor));
        this.addSupportedExtensionsToMap(resourceEncryptorMap, new CipherResourcePropertiesEncryptor(this.encryptor));
        this.addSupportedExtensionsToMap(resourceEncryptorMap, new CipherResourceYamlEncryptor(this.encryptor));
        return resourceEncryptorMap;
    }

    private void addSupportedExtensionsToMap(Map<String, ResourceEncryptor> resourceEncryptorMap, ResourceEncryptor resourceEncryptor) {
        for (String ext : resourceEncryptor.getSupportedExtensions()) {
            resourceEncryptorMap.put(ext, resourceEncryptor);
        }
    }
}

