/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.JdbcEnvironmentProperties;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.util.StringUtils;

public class JdbcEnvironmentRepository
implements EnvironmentRepository,
Ordered {
    private static final Log logger = LogFactory.getLog(JdbcEnvironmentRepository.class);
    private final JdbcTemplate jdbc;
    private final PropertiesResultSetExtractor extractor = new PropertiesResultSetExtractor();
    private int order;
    private String sql;
    private boolean failOnError;

    public JdbcEnvironmentRepository(JdbcTemplate jdbc, JdbcEnvironmentProperties properties) {
        this.jdbc = jdbc;
        this.order = properties.getOrder();
        this.sql = properties.getSql();
        this.failOnError = properties.isFailOnError();
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    public Environment findOne(String application, String profile, String label) {
        String config = application;
        if (StringUtils.isEmpty((Object)label)) {
            label = "master";
        }
        if (StringUtils.isEmpty((Object)profile)) {
            profile = "default";
        }
        if (!profile.startsWith("default")) {
            profile = "default," + profile;
        }
        String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
        Environment environment = new Environment(application, profiles, label, null, null);
        if (!config.startsWith("application")) {
            config = "application," + config;
        }
        ArrayList<String> applications = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)config))));
        ArrayList<String> envs = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(profiles)));
        Collections.reverse(applications);
        Collections.reverse(envs);
        for (String app : applications) {
            for (String env : envs) {
                try {
                    Map next = (Map)this.jdbc.query(this.sql, (ResultSetExtractor)this.extractor, new Object[]{app, env, label});
                    if (next == null || next.isEmpty()) continue;
                    environment.add(new PropertySource(app + "-" + env, next));
                }
                catch (DataAccessException e) {
                    if (!this.failOnError) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)"Failed to retrieve configuration from JDBC Repository", (Throwable)e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        return environment;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public static class PropertiesResultSetExtractor
    implements ResultSetExtractor<Map<String, String>> {
        public Map<String, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
            return map;
        }
    }
}

