/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.util.StringUtils;

public class AwsSecretsManagerEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsSecretsManagerEnvironmentRepository, AwsSecretsManagerEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsSecretsManagerEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsSecretsManagerEnvironmentRepository build(AwsSecretsManagerEnvironmentProperties environmentProperties) {
        AWSSecretsManagerClientBuilder clientBuilder = AWSSecretsManagerClientBuilder.standard();
        String region = environmentProperties.getRegion();
        if (!StringUtils.isEmpty((Object)region)) {
            Regions awsRegion = Regions.fromName((String)region);
            clientBuilder.withRegion(awsRegion);
            String endpoint = environmentProperties.getEndpoint();
            if (!StringUtils.isEmpty((Object)endpoint)) {
                AwsClientBuilder.EndpointConfiguration endpointConfiguration = new AwsClientBuilder.EndpointConfiguration(endpoint, awsRegion.getName());
                clientBuilder.withEndpointConfiguration(endpointConfiguration);
            }
        }
        AWSSecretsManager client = (AWSSecretsManager)clientBuilder.build();
        return new AwsSecretsManagerEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

