/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.AwsClientBuilderConfigurer;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentProperties;
import org.springframework.cloud.config.server.environment.AwsSecretsManagerEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;

public class AwsSecretsManagerEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<AwsSecretsManagerEnvironmentRepository, AwsSecretsManagerEnvironmentProperties> {
    private final ConfigServerProperties configServerProperties;

    public AwsSecretsManagerEnvironmentRepositoryFactory(ConfigServerProperties configServerProperties) {
        this.configServerProperties = configServerProperties;
    }

    @Override
    public AwsSecretsManagerEnvironmentRepository build(AwsSecretsManagerEnvironmentProperties environmentProperties) {
        AWSSecretsManagerClientBuilder clientBuilder = AWSSecretsManagerClientBuilder.standard();
        AwsClientBuilderConfigurer.configureClientBuilder(clientBuilder, environmentProperties.getRegion(), environmentProperties.getEndpoint());
        AWSSecretsManager client = (AWSSecretsManager)clientBuilder.build();
        return new AwsSecretsManagerEnvironmentRepository(client, this.configServerProperties, environmentProperties);
    }
}

