/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategy;
import org.springframework.cloud.config.server.environment.VaultKvAccessStrategySupport;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;

public final class VaultKvAccessStrategyFactory {
    private VaultKvAccessStrategyFactory() {
        throw new IllegalStateException("Can't instantiate an utility class");
    }

    public static VaultKvAccessStrategy forVersion(RestOperations rest, String baseUrl, int version, String pathToKey) {
        switch (version) {
            case 1: {
                return new V1VaultKvAccessStrategy(baseUrl, rest);
            }
            case 2: {
                return new V2VaultKvAccessStrategy(baseUrl, pathToKey, rest);
            }
        }
        throw new IllegalArgumentException("No support for given Vault k/v backend version " + version);
    }

    static class V2VaultKvAccessStrategy
    extends VaultKvAccessStrategySupport {
        private String pathToKey;

        V2VaultKvAccessStrategy(String baseUrl, String pathToKey, RestOperations rest) {
            super(baseUrl, rest);
            this.pathToKey = pathToKey;
        }

        @Override
        public String getPath() {
            if (StringUtils.hasText((String)this.pathToKey)) {
                return "data/" + this.pathToKey + "/{key}";
            }
            return "data/{key}";
        }

        @Override
        public String extractDataFromBody(VaultKvAccessStrategy.VaultResponse body) {
            JsonNode nestedDataNode = body.getData() == null ? null : ((JsonNode)body.getData()).get("data");
            return nestedDataNode == null ? null : nestedDataNode.toString();
        }
    }

    static class V1VaultKvAccessStrategy
    extends VaultKvAccessStrategySupport {
        V1VaultKvAccessStrategy(String baseUrl, RestOperations rest) {
            super(baseUrl, rest);
        }

        @Override
        public String getPath() {
            return "{key}";
        }

        @Override
        public String extractDataFromBody(VaultKvAccessStrategy.VaultResponse body) {
            return body.getData() == null ? null : body.getData().toString();
        }
    }
}

