/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.HttpClientConnection;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.support.HttpClient4Support;
import org.springframework.util.ObjectUtils;

public class HttpClientConfigurableHttpConnectionFactory
implements ConfigurableHttpConnectionFactory {
    private static final String PLACEHOLDER_PATTERN_STRING = "\\{(\\w+)}";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(\\w+)}");
    Log log = LogFactory.getLog(this.getClass());
    Map<String, HttpClientBuilder> httpClientBuildersByUri = new LinkedHashMap<String, HttpClientBuilder>();

    @Override
    public void addConfiguration(MultipleJGitEnvironmentProperties environmentProperties) throws GeneralSecurityException {
        this.addHttpClient(environmentProperties);
        for (JGitEnvironmentProperties jGitEnvironmentProperties : environmentProperties.getRepos().values()) {
            this.addHttpClient(jGitEnvironmentProperties);
        }
    }

    public HttpConnection create(URL url) throws IOException {
        return this.create(url, null);
    }

    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        HttpClientBuilder builder = this.lookupHttpClientBuilder(url);
        if (builder != null) {
            return new HttpClientConnection(url.toString(), null, (HttpClient)builder.build());
        }
        return new HttpClientConnection(url.toString());
    }

    private void addHttpClient(JGitEnvironmentProperties properties) throws GeneralSecurityException {
        if (properties.getUri() != null && properties.getUri().startsWith("http")) {
            this.httpClientBuildersByUri.put(properties.getUri(), HttpClient4Support.builder(properties));
        }
    }

    private HttpClientBuilder lookupHttpClientBuilder(URL url) {
        Map<String, HttpClientBuilder> builderMap = this.httpClientBuildersByUri.entrySet().stream().filter(entry -> {
            String key = (String)entry.getKey();
            String spec = this.getUrlWithPlaceholders(url, key);
            if (spec.equals(key)) {
                return true;
            }
            int index = spec.lastIndexOf("/");
            while (index != -1) {
                if ((spec = spec.substring(0, index)).equals(key)) {
                    return true;
                }
                index = spec.lastIndexOf("/");
            }
            return false;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (builderMap.isEmpty()) {
            this.log.warn((Object)String.format("No custom http config found for URL: %s", url));
            return null;
        }
        if (builderMap.size() > 1) {
            List keys = builderMap.keySet().stream().filter(key -> !PLACEHOLDER_PATTERN.matcher((CharSequence)key).find()).collect(Collectors.toList());
            if (keys.size() == 1) {
                return builderMap.get(keys.get(0));
            }
            this.log.error((Object)String.format("More than one git repo URL template matched URL: %s, proxy and skipSslValidation config won't be applied. Matched templates: %s", url, builderMap.keySet().stream().collect(Collectors.joining(", "))));
            return null;
        }
        return new ArrayList<HttpClientBuilder>(builderMap.values()).get(0);
    }

    private String getUrlWithPlaceholders(URL url, String key) {
        String spec = url.toString();
        String[] tokens = key.split(PLACEHOLDER_PATTERN_STRING);
        if (tokens.length >= 1 && !tokens[0].equals(url.toString())) {
            List<String> placeholders = this.getPlaceholders(key);
            List<String> values = this.getValues(spec, tokens);
            if (placeholders.size() == values.size()) {
                for (int i = 0; i < values.size(); ++i) {
                    spec = spec.replace(values.get(i), String.format("{%s}", placeholders.get(i)));
                }
            }
        }
        return spec;
    }

    private List<String> getValues(String spec, String[] tokens) {
        LinkedList<String> values = new LinkedList<String>();
        for (String token : tokens) {
            String[] valueTokens = spec.split(token);
            if (!ObjectUtils.isEmpty((Object)valueTokens[0])) {
                values.add(valueTokens[0]);
            }
            if (valueTokens.length <= 1) continue;
            spec = valueTokens[1];
        }
        if (tokens.length == 1 && !ObjectUtils.isEmpty((Object)spec)) {
            values.add(spec);
        }
        return values;
    }

    private List<String> getPlaceholders(String key) {
        Pattern pattern = Pattern.compile(PLACEHOLDER_PATTERN_STRING);
        Matcher matcher = pattern.matcher(key);
        LinkedList<String> placeholders = new LinkedList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group(1));
        }
        return placeholders;
    }
}

