/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.proxy;

import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.cloud.config.server.proxy.ProxyHostProperties;

public class SchemeBasedRoutePlanner
extends DefaultRoutePlanner {
    private final HttpHost httpsProxy;
    private final HttpHost defaultSchemeProxy;

    public SchemeBasedRoutePlanner(ProxyHostProperties httpsProxy, ProxyHostProperties httpProxy) {
        super(null);
        this.httpsProxy = this.buildProxy(httpsProxy, "https");
        this.defaultSchemeProxy = this.buildProxy(httpProxy, HttpHost.DEFAULT_SCHEME.getId());
    }

    protected HttpHost determineProxy(HttpHost target, HttpContext context) {
        return "https".equals(target.getSchemeName()) ? this.determineProxy(this.httpsProxy, this.defaultSchemeProxy) : this.determineProxy(this.defaultSchemeProxy, this.httpsProxy);
    }

    private HttpHost determineProxy(HttpHost proxy, HttpHost fallbackProxy) {
        return proxy != null ? proxy : fallbackProxy;
    }

    private HttpHost buildProxy(ProxyHostProperties properties, String scheme) {
        if (properties == null || !properties.connectionInformationProvided()) {
            return null;
        }
        return new HttpHost(scheme, properties.getHost(), properties.getPort());
    }
}

