/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.secretmanager;

import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.secretmanager.v1.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.ListSecretVersionsRequest;
import com.google.cloud.secretmanager.v1.ListSecretsRequest;
import com.google.cloud.secretmanager.v1.ProjectName;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretManagerServiceSettings;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretVersion;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleConfigProvider;
import org.springframework.cloud.config.server.environment.secretmanager.GoogleSecretManagerAccessStrategy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class GoogleSecretManagerV1AccessStrategy
implements GoogleSecretManagerAccessStrategy {
    private final SecretManagerServiceClient client;
    private final RestTemplate rest;
    private final GoogleConfigProvider configProvider;
    private static final String APPLICATION_NAME = "spring-cloud-config-server";
    private static final String ACCESS_SECRET_PERMISSION = "secretmanager.versions.access";
    private static Log logger = LogFactory.getLog(GoogleSecretManagerV1AccessStrategy.class);

    public GoogleSecretManagerV1AccessStrategy(RestTemplate rest, GoogleConfigProvider configProvider, String serviceAccountFile) throws IOException {
        if (StringUtils.hasText((String)serviceAccountFile)) {
            GoogleCredentials creds = GoogleCredentials.fromStream((InputStream)new FileInputStream(new File(serviceAccountFile)));
            this.client = SecretManagerServiceClient.create((SecretManagerServiceSettings)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)creds))).build());
        } else {
            this.client = SecretManagerServiceClient.create();
        }
        this.rest = rest;
        this.configProvider = configProvider;
    }

    public GoogleSecretManagerV1AccessStrategy(RestTemplate rest, GoogleConfigProvider configProvider, SecretManagerServiceClient client) {
        this.client = client;
        this.rest = rest;
        this.configProvider = configProvider;
    }

    public List<Secret> getSecrets() {
        ProjectName project = ProjectName.of((String)this.getProjectId());
        ListSecretsRequest listSecretRequest = ListSecretsRequest.newBuilder().setParent(project.toString()).build();
        SecretManagerServiceClient.ListSecretsPagedResponse pagedListSecretResponse = this.client.listSecrets(listSecretRequest);
        ArrayList<Secret> result = new ArrayList<Secret>();
        pagedListSecretResponse.iterateAll().forEach(result::add);
        return result;
    }

    private List<SecretVersion> getSecretVersions(Secret secret) {
        SecretName parent = SecretName.parse((String)secret.getName());
        ListSecretVersionsRequest listVersionRequest = ListSecretVersionsRequest.newBuilder().setParent(parent.toString()).build();
        SecretManagerServiceClient.ListSecretVersionsPagedResponse pagedListVersionResponse = this.client.listSecretVersions(listVersionRequest);
        ArrayList<SecretVersion> result = new ArrayList<SecretVersion>();
        pagedListVersionResponse.iterateAll().forEach(result::add);
        return result;
    }

    @Override
    public String getSecretValue(Secret secret, Comparator<SecretVersion> comparator) {
        String result = null;
        List<SecretVersion> versions = this.getSecretVersions(secret);
        SecretVersion winner = null;
        for (SecretVersion secretVersion : versions) {
            if (secretVersion.getState().getNumber() != 1 || comparator.compare(secretVersion, winner) <= 0) continue;
            winner = secretVersion;
        }
        if (winner != null) {
            SecretVersionName name = SecretVersionName.parse((String)winner.getName());
            AccessSecretVersionRequest request = AccessSecretVersionRequest.newBuilder().setName(name.toString()).build();
            AccessSecretVersionResponse response = this.client.accessSecretVersion(request);
            result = response.getPayload().getData().toStringUtf8();
        }
        return result;
    }

    @Override
    public String getSecretName(Secret secret) {
        SecretName parent = SecretName.parse((String)secret.getName());
        return parent.getSecret();
    }

    @Override
    public Boolean checkRemotePermissions() {
        CloudResourceManager service = null;
        try {
            AccessToken accessToken = new AccessToken(this.getAccessToken(), null);
            GoogleCredentials credential = new GoogleCredentials(accessToken);
            HttpCredentialsAdapter requestInitializer = new HttpCredentialsAdapter((Credentials)credential);
            service = new CloudResourceManager.Builder((HttpTransport)GoogleNetHttpTransport.newTrustedTransport(), (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)requestInitializer).setApplicationName(APPLICATION_NAME).build();
            List<String> permissionsList = Arrays.asList(ACCESS_SECRET_PERMISSION);
            TestIamPermissionsRequest requestBody = new TestIamPermissionsRequest().setPermissions(permissionsList);
            TestIamPermissionsResponse testIamPermissionsResponse = (TestIamPermissionsResponse)service.projects().testIamPermissions(this.getProjectId(), requestBody).execute();
            if (testIamPermissionsResponse.getPermissions() != null && testIamPermissionsResponse.size() >= 1) {
                return Boolean.TRUE;
            }
            logger.warn((Object)"Access token has no permissions to access secrets in project");
            return Boolean.FALSE;
        }
        catch (Exception e) {
            logger.info((Object)"Unable to check token permissions", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private String getAccessToken() {
        return this.configProvider.getValue("X-Config-Token", true);
    }

    private String getProjectId() {
        String result = null;
        try {
            result = this.configProvider.getValue("X-Project-ID", true);
        }
        catch (Exception e) {
            HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)GoogleSecretManagerV1AccessStrategy.getMetadataHttpHeaders());
            result = (String)this.rest.exchange("http://metadata.google.internal/computeMetadata/v1/project/project-id", HttpMethod.GET, entity, String.class, new Object[0]).getBody();
        }
        return result;
    }

    private static HttpHeaders getMetadataHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Metadata-Flavor", "Google");
        return headers;
    }
}

