/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.environment.PropertySource;
import org.springframework.cloud.config.server.environment.EnvironmentException;
import org.springframework.cloud.config.server.environment.EnvironmentNotFoundException;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.InvalidEnvironmentRequestException;
import org.springframework.cloud.config.server.environment.RepositoryException;
import org.springframework.cloud.config.server.support.EnvironmentPropertySource;
import org.springframework.cloud.config.server.support.PathUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import tools.jackson.databind.json.JsonMapper;

@RestController
@RequestMapping(method={RequestMethod.GET}, path={"${spring.cloud.config.server.prefix:}"})
public class EnvironmentController {
    private static final Log LOG = LogFactory.getLog(EnvironmentController.class);
    private EnvironmentRepository repository;
    private JsonMapper objectMapper;
    private boolean stripDocument = true;
    private boolean acceptEmpty = true;

    public EnvironmentController(EnvironmentRepository repository) {
        this(repository, new JsonMapper());
    }

    public EnvironmentController(EnvironmentRepository repository, JsonMapper objectMapper) {
        this.repository = repository;
        this.objectMapper = objectMapper;
    }

    public void setStripDocumentFromYaml(boolean stripDocument) {
        this.stripDocument = stripDocument;
    }

    public void setAcceptEmpty(boolean acceptEmpty) {
        this.acceptEmpty = acceptEmpty;
    }

    @GetMapping(path={"/{name}/{profiles:(?!.*\\b\\.(?:ya?ml|properties|json)\\b).*}"}, produces={"application/json"})
    public Environment defaultLabel(@PathVariable String name, @PathVariable String profiles) {
        return this.getEnvironment(name, profiles, null, false);
    }

    @GetMapping(path={"/{name}/{profiles:(?!.*\\b\\.(?:ya?ml|properties|json)\\b).*}"}, produces={"application/vnd.spring-cloud.config-server.v2+json"})
    public Environment defaultLabelIncludeOrigin(@PathVariable String name, @PathVariable String profiles) {
        return this.getEnvironment(name, profiles, null, true);
    }

    @GetMapping(path={"/{name}/{profiles}/{label:.*}"}, produces={"application/json"})
    public Environment labelled(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        return this.getEnvironment(name, profiles, label, false);
    }

    @GetMapping(path={"/{name}/{profiles}/{label:.*}"}, produces={"application/vnd.spring-cloud.config-server.v2+json"})
    public Environment labelledIncludeOrigin(@PathVariable String name, @PathVariable String profiles, @PathVariable String label) {
        return this.getEnvironment(name, profiles, label, true);
    }

    public Environment getEnvironment(String name, String profiles, String label, boolean includeOrigin) {
        try {
            name = this.normalize(name);
            label = this.normalize(label);
            Environment environment = this.repository.findOne(name, profiles, label, includeOrigin);
            if (!this.acceptEmpty && (environment == null || environment.getPropertySources().isEmpty())) {
                throw new EnvironmentNotFoundException("Profile Not found");
            }
            return environment;
        }
        catch (Exception e) {
            LOG.warn((Object)String.format("Error getting the Environment with name=%s profiles=%s label=%s includeOrigin=%b", name, profiles, label, includeOrigin), (Throwable)e);
            throw e;
        }
    }

    private String normalize(String part) {
        if (PathUtils.isInvalidEncodedLocation(part)) {
            throw new InvalidEnvironmentRequestException("Invalid request");
        }
        return Environment.normalize((String)part);
    }

    @GetMapping(value={"/{name}-{profiles}.properties"})
    public ResponseEntity<String> properties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        return this.labelledProperties(name, profiles, null, resolvePlaceholders);
    }

    @GetMapping(value={"/{label}/{name}-{profiles}.properties"})
    public ResponseEntity<String> labelledProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws IOException {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToProperties(environment);
        String propertiesString = this.getPropertiesString(properties);
        if (resolvePlaceholders) {
            propertiesString = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), propertiesString);
        }
        return this.getSuccess(propertiesString);
    }

    @GetMapping(value={"{name}-{profiles}.json"})
    public ResponseEntity<String> jsonProperties(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledJsonProperties(name, profiles, null, resolvePlaceholders);
    }

    @GetMapping(value={"/{label}/{name}-{profiles}.json"})
    public ResponseEntity<String> labelledJsonProperties(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> properties = this.convertToMap(environment);
        String json = this.objectMapper.writeValueAsString(properties);
        if (resolvePlaceholders) {
            json = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), json);
        }
        return this.getSuccess(json, MediaType.APPLICATION_JSON);
    }

    private String getPropertiesString(Map<String, Object> properties) {
        StringBuilder output = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (output.length() > 0) {
                output.append("\n");
            }
            output.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        return output.toString();
    }

    @GetMapping(value={"/{name}-{profiles}.yml", "/{name}-{profiles}.yaml"})
    public ResponseEntity<String> yaml(@PathVariable String name, @PathVariable String profiles, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        return this.labelledYaml(name, profiles, null, resolvePlaceholders);
    }

    @GetMapping(value={"/{label}/{name}-{profiles}.yml", "/{label}/{name}-{profiles}.yaml"})
    public ResponseEntity<String> labelledYaml(@PathVariable String name, @PathVariable String profiles, @PathVariable String label, @RequestParam(defaultValue="true") boolean resolvePlaceholders) throws Exception {
        this.validateProfiles(profiles);
        Environment environment = this.labelled(name, profiles, label);
        Map<String, Object> result = this.convertToMap(environment);
        if (this.stripDocument && result.size() == 1 && result.keySet().iterator().next().equals("document")) {
            Object value = result.get("document");
            if (value instanceof Collection) {
                return this.getSuccess(new Yaml().dumpAs(value, Tag.SEQ, DumperOptions.FlowStyle.BLOCK));
            }
            return this.getSuccess(new Yaml().dumpAs(value, Tag.STR, DumperOptions.FlowStyle.BLOCK));
        }
        String yaml = new Yaml().dumpAsMap(result);
        if (resolvePlaceholders) {
            yaml = EnvironmentPropertySource.resolvePlaceholders(EnvironmentPropertySource.prepareEnvironment(environment), yaml);
        }
        return this.getSuccess(yaml);
    }

    private Map<String, Object> convertToMap(Environment input) {
        Map<String, Object> properties = this.convertToProperties(input);
        LinkedHashMap<String, Object> rootMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            PropertyNavigator nav = new PropertyNavigator(key);
            nav.setMapValue(rootMap, value);
        }
        return rootMap;
    }

    @ExceptionHandler(value={RepositoryException.class})
    public void noSuchLabel(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.NOT_FOUND.value());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public void illegalArgument(HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value());
    }

    @ExceptionHandler(value={EnvironmentException.class})
    public void environmentException(HttpServletResponse response, EnvironmentException e) throws IOException {
        response.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), e.getMessage());
    }

    private void validateProfiles(String profiles) {
        if (profiles.contains("-")) {
            throw new IllegalArgumentException("Properties output not supported for name or profiles containing hyphens");
        }
    }

    private HttpHeaders getHttpHeaders(MediaType mediaType) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(mediaType);
        return httpHeaders;
    }

    private ResponseEntity<String> getSuccess(String body) {
        return new ResponseEntity((Object)body, this.getHttpHeaders(MediaType.TEXT_PLAIN), (HttpStatusCode)HttpStatus.OK);
    }

    private ResponseEntity<String> getSuccess(String body, MediaType mediaType) {
        return new ResponseEntity((Object)body, this.getHttpHeaders(mediaType), (HttpStatusCode)HttpStatus.OK);
    }

    private Map<String, Object> convertToProperties(Environment profiles) {
        ArrayList sources = new ArrayList(profiles.getPropertySources());
        Collections.reverse(sources);
        LinkedHashMap<String, Object> combinedMap = new LinkedHashMap<String, Object>();
        LinkedHashMap arrayMap = new LinkedHashMap();
        for (PropertySource propertySource : sources) {
            Map value = propertySource.getSource();
            LinkedHashMap<String, Map> currentArrayMap = new LinkedHashMap<String, Map>();
            for (Map.Entry entry : value.entrySet()) {
                if (!((String)entry.getKey()).contains("[")) {
                    combinedMap.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                String prefixKey = ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf("["));
                currentArrayMap.computeIfAbsent(prefixKey, k -> new LinkedHashMap()).put((String)entry.getKey(), entry.getValue());
            }
            arrayMap.putAll(currentArrayMap);
        }
        for (Map.Entry entry : arrayMap.entrySet()) {
            combinedMap.putAll((Map)entry.getValue());
        }
        this.postProcessProperties(combinedMap);
        return combinedMap;
    }

    private void postProcessProperties(Map<String, Object> propertiesMap) {
        propertiesMap.keySet().removeIf(key -> key.equals("spring.profiles"));
    }

    private static final class PropertyNavigator {
        private final String propertyKey;
        private String prefix = "";
        private int currentPos;
        private NodeType valueType;

        private PropertyNavigator(String propertyKey) {
            this.propertyKey = propertyKey;
            this.currentPos = -1;
            this.valueType = NodeType.MAP;
        }

        private void setMapValue(Map<String, Object> map, Object value) {
            String key = this.getKey();
            if (NodeType.MAP.equals((Object)this.valueType)) {
                Map<String, Object> nestedMap;
                if (map.get(key) instanceof Map) {
                    nestedMap = (LinkedHashMap<String, Object>)map.get(key);
                } else if (map.get(key) != null) {
                    this.prefix = key + ".";
                    nestedMap = map;
                } else {
                    nestedMap = new LinkedHashMap<String, Object>();
                    map.put(key, nestedMap);
                }
                this.setMapValue(nestedMap, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> list = (ArrayList<Object>)map.get(key);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(key, list);
                }
                this.setListValue(list, value);
            } else {
                map.put(this.prefix + key, value);
            }
        }

        private void setListValue(List<Object> list, Object value) {
            int index = this.getIndex();
            while (list.size() <= index) {
                list.add(null);
            }
            if (NodeType.MAP.equals((Object)this.valueType)) {
                LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>)list.get(index);
                if (map == null) {
                    map = new LinkedHashMap<String, Object>();
                    list.set(index, map);
                }
                this.setMapValue(map, value);
            } else if (NodeType.ARRAY.equals((Object)this.valueType)) {
                ArrayList<Object> nestedList = (ArrayList<Object>)list.get(index);
                if (nestedList == null) {
                    nestedList = new ArrayList<Object>();
                    list.set(index, nestedList);
                }
                this.setListValue(nestedList, value);
            } else {
                list.set(index, value);
            }
        }

        private int getIndex() {
            int start;
            for (int i = start = this.currentPos + 1; i < this.propertyKey.length(); ++i) {
                char c = this.propertyKey.charAt(i);
                if (c == ']') {
                    this.currentPos = i;
                    break;
                }
                if (Character.isDigit(c)) continue;
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            if (this.currentPos < start || this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            int index = Integer.parseInt(this.propertyKey.substring(start, this.currentPos));
            ++this.currentPos;
            if (this.currentPos == this.propertyKey.length()) {
                this.valueType = NodeType.LEAF;
            } else {
                switch (this.propertyKey.charAt(this.currentPos)) {
                    case '.': {
                        this.valueType = NodeType.MAP;
                        break;
                    }
                    case '[': {
                        this.valueType = NodeType.ARRAY;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
                    }
                }
            }
            return index;
        }

        private String getKey() {
            int start = this.currentPos + 1;
            int openingBracketPosition = -1;
            for (int i = start; i < this.propertyKey.length(); ++i) {
                char currentChar = this.propertyKey.charAt(i);
                if (currentChar == '.') {
                    this.valueType = NodeType.MAP;
                    this.currentPos = i;
                    break;
                }
                if (currentChar == '[') {
                    openingBracketPosition = i;
                    continue;
                }
                if (currentChar != ']') continue;
                String bracketContents = this.propertyKey.substring(openingBracketPosition + 1, i);
                try {
                    Integer.parseInt(bracketContents);
                    this.valueType = NodeType.ARRAY;
                    this.currentPos = openingBracketPosition;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.currentPos < start) {
                this.currentPos = this.propertyKey.length();
                this.valueType = NodeType.LEAF;
            } else if (this.currentPos == start) {
                throw new IllegalArgumentException("Invalid key: " + this.propertyKey);
            }
            return this.propertyKey.substring(start, this.currentPos);
        }

        private static enum NodeType {
            LEAF,
            MAP,
            ARRAY;

        }
    }
}

