/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.binder;

import com.ecwid.consul.v1.OperationException;
import com.ecwid.consul.v1.event.model.Event;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.consul.binder.EventService;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.util.Base64Utils;

public class ConsulInboundMessageProducer
extends MessageProducerSupport {
    protected static final Log logger = LogFactory.getLog(ConsulInboundMessageProducer.class);
    private final ScheduledExecutorService scheduler;
    private final Runnable eventsRunnable;
    private EventService eventService;
    private ScheduledFuture<?> eventsHandle;

    public ConsulInboundMessageProducer(EventService eventService) {
        this.eventService = eventService;
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.eventsRunnable = new Runnable(){

            @Override
            public void run() {
                ConsulInboundMessageProducer.this.getEvents();
            }
        };
    }

    protected void doStart() {
        this.eventsHandle = this.scheduler.scheduleWithFixedDelay(this.eventsRunnable, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.eventsHandle != null) {
            this.eventsHandle.cancel(true);
        }
        this.scheduler.shutdown();
    }

    public void getEvents() {
        block6: {
            try {
                List<Event> events = this.eventService.watch();
                for (Event event : events) {
                    String decoded = new String(Base64Utils.decodeFromString((String)event.getPayload()));
                    this.sendMessage(this.getMessageBuilderFactory().withPayload((Object)decoded).build());
                }
            }
            catch (OperationException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Error getting consul events: " + (Object)((Object)e)));
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)("Error getting consul events: " + e.getMessage()));
                }
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)"Error getting consul events", (Throwable)e);
            }
        }
    }
}

