/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import java.util.function.Function;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.Bootstrapper;
import org.springframework.cloud.consul.ConsulProperties;

public abstract class ConsulBootstrapper {
    static Bootstrapper fromConsulProperties(Function<ConsulProperties, ConsulClient> factory) {
        return registry -> registry.register(ConsulClient.class, context -> {
            ConsulProperties properties = (ConsulProperties)context.get(ConsulProperties.class);
            return (ConsulClient)factory.apply(properties);
        });
    }

    static Bootstrapper fromBootstrapContext(Function<BootstrapContext, ConsulClient> factory) {
        return registry -> registry.register(ConsulClient.class, factory::apply);
    }
}

