/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulPropertySources;
import org.springframework.core.style.ToStringCreator;

public class ConsulConfigDataResource
extends ConfigDataResource {
    private final ConsulConfigProperties properties;
    private final String context;
    private final boolean optional;
    private final ConsulPropertySources consulPropertySources;
    private final String profile;

    public ConsulConfigDataResource(String context, ConsulConfigProperties properties, ConsulPropertySources consulPropertySources, String profile) {
        this.properties = properties;
        this.context = context;
        this.optional = true;
        this.consulPropertySources = consulPropertySources;
        this.profile = profile;
    }

    @Deprecated
    public ConsulConfigDataResource(String context, ConsulConfigProperties properties, ConsulPropertySources consulPropertySources) {
        this(context, true, properties, consulPropertySources);
    }

    @Deprecated
    public ConsulConfigDataResource(String context, boolean optional, ConsulConfigProperties properties, ConsulPropertySources consulPropertySources) {
        this.properties = properties;
        this.context = context;
        this.optional = optional;
        this.consulPropertySources = consulPropertySources;
        this.profile = null;
    }

    public String getContext() {
        return this.context;
    }

    @Deprecated
    public boolean isOptional() {
        return this.optional;
    }

    public ConsulConfigProperties getProperties() {
        return this.properties;
    }

    public ConsulPropertySources getConsulPropertySources() {
        return this.consulPropertySources;
    }

    String getProfile() {
        return this.profile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ConsulConfigDataResource that = (ConsulConfigDataResource)((Object)o);
        return this.optional == that.optional && this.context.equals(that.context) && Objects.equals(this.profile, that.profile);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.optional, this.profile);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("context", (Object)this.context).append("optional", this.optional).append("properties", (Object)this.properties).append("profile", (Object)this.profile).toString();
    }
}

