/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import com.ecwid.consul.v1.agent.model.NewService;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ConsulAutoRegistration
extends ConsulRegistration {
    public static final char SEPARATOR = '-';
    private final ApplicationContext context;
    private final HeartbeatProperties heartbeatProperties;

    public ConsulAutoRegistration(NewService service, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties) {
        super(service, properties);
        this.context = context;
        this.heartbeatProperties = heartbeatProperties;
    }

    public void initializePort(int knownPort) {
        if (this.getService().getPort() == null) {
            this.getService().setPort(Integer.valueOf(knownPort));
        }
        ConsulAutoRegistration.setCheck(this.getService(), this.getProperties(), this.context, this.heartbeatProperties);
    }

    public ConsulAutoRegistration managementRegistration() {
        return ConsulAutoRegistration.managementRegistration(this.getProperties(), this.context, this.heartbeatProperties);
    }

    public static ConsulAutoRegistration registration(ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, HeartbeatProperties heartbeatProperties) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment());
        NewService service = new NewService();
        String appName = ConsulAutoRegistration.getAppName(properties, propertyResolver);
        service.setId(ConsulAutoRegistration.getInstanceId(properties, context));
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(properties.getHostname());
        }
        service.setName(ConsulAutoRegistration.normalizeForDns(appName));
        service.setTags(ConsulAutoRegistration.createTags(properties));
        if (properties.getPort() != null) {
            service.setPort(properties.getPort());
            ConsulAutoRegistration.setCheck(service, properties, context, heartbeatProperties);
        }
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, properties, context, heartbeatProperties);
        ConsulAutoRegistration.customize(registrationCustomizers, registration);
        return registration;
    }

    public static void customize(List<ConsulRegistrationCustomizer> registrationCustomizers, ConsulAutoRegistration registration) {
        if (registrationCustomizers != null) {
            for (ConsulRegistrationCustomizer customizer : registrationCustomizers) {
                customizer.customize(registration);
            }
        }
    }

    @Deprecated
    public static ConsulAutoRegistration lifecycleRegistration(Integer port, String instanceId, ConsulDiscoveryProperties properties, ApplicationContext context, List<ConsulRegistrationCustomizer> registrationCustomizers, HeartbeatProperties heartbeatProperties) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment());
        NewService service = new NewService();
        String appName = ConsulAutoRegistration.getAppName(properties, propertyResolver);
        service.setId(instanceId);
        if (!properties.isPreferAgentAddress()) {
            service.setAddress(properties.getHostname());
        }
        service.setName(ConsulAutoRegistration.normalizeForDns(appName));
        service.setTags(ConsulAutoRegistration.createTags(properties));
        if (properties.getPort() != null) {
            service.setPort(properties.getPort());
        } else {
            service.setPort(port);
        }
        Assert.notNull((Object)service.getPort(), (String)"service.port may not be null");
        ConsulAutoRegistration.setCheck(service, properties, context, heartbeatProperties);
        ConsulAutoRegistration registration = new ConsulAutoRegistration(service, properties, context, heartbeatProperties);
        ConsulAutoRegistration.customize(registrationCustomizers, registration);
        return registration;
    }

    public static void setCheck(NewService service, ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties) {
        if (properties.isRegisterHealthCheck() && service.getCheck() == null) {
            Integer checkPort = ConsulAutoRegistration.shouldRegisterManagement(properties, context) ? ConsulAutoRegistration.getManagementPort(properties, context) : service.getPort();
            Assert.notNull((Object)checkPort, (String)"checkPort may not be null");
            service.setCheck(ConsulAutoRegistration.createCheck(checkPort, heartbeatProperties, properties));
        }
    }

    public static ConsulAutoRegistration managementRegistration(ConsulDiscoveryProperties properties, ApplicationContext context, HeartbeatProperties heartbeatProperties) {
        RelaxedPropertyResolver propertyResolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment());
        NewService management = new NewService();
        management.setId(ConsulAutoRegistration.getManagementServiceId(properties, context));
        management.setAddress(properties.getHostname());
        management.setName(ConsulAutoRegistration.getManagementServiceName(properties, propertyResolver));
        management.setPort(ConsulAutoRegistration.getManagementPort(properties, context));
        management.setTags(properties.getManagementTags());
        if (properties.isRegisterHealthCheck()) {
            management.setCheck(ConsulAutoRegistration.createCheck(ConsulAutoRegistration.getManagementPort(properties, context), heartbeatProperties, properties));
        }
        return new ConsulAutoRegistration(management, properties, context, heartbeatProperties);
    }

    public static String getInstanceId(ConsulDiscoveryProperties properties, ApplicationContext context) {
        if (!StringUtils.hasText((String)properties.getInstanceId())) {
            return ConsulAutoRegistration.normalizeForDns(context.getId());
        }
        return ConsulAutoRegistration.normalizeForDns(properties.getInstanceId());
    }

    public static String normalizeForDns(String s) {
        if (s == null || !Character.isLetter(s.charAt(0)) || !Character.isLetterOrDigit(s.charAt(s.length() - 1))) {
            throw new IllegalArgumentException("Consul service ids must not be empty, must start with a letter, end with a letter or digit, and have as interior characters only letters, digits, and hyphen");
        }
        StringBuilder normalized = new StringBuilder();
        Character prev = null;
        for (char curr : s.toCharArray()) {
            Character toAppend = null;
            if (Character.isLetterOrDigit(curr)) {
                toAppend = Character.valueOf(curr);
            } else if (prev == null || prev.charValue() != '-') {
                toAppend = Character.valueOf('-');
            }
            if (toAppend == null) continue;
            normalized.append(toAppend);
            prev = toAppend;
        }
        return normalized.toString();
    }

    public static List<String> createTags(ConsulDiscoveryProperties properties) {
        LinkedList<String> tags = new LinkedList<String>(properties.getTags());
        if (!StringUtils.isEmpty((Object)properties.getInstanceZone())) {
            tags.add(properties.getDefaultZoneMetadataName() + "=" + properties.getInstanceZone());
        }
        if (!StringUtils.isEmpty((Object)properties.getInstanceGroup())) {
            tags.add("group=" + properties.getInstanceGroup());
        }
        return tags;
    }

    public static NewService.Check createCheck(Integer port, HeartbeatProperties ttlConfig, ConsulDiscoveryProperties properties) {
        NewService.Check check = new NewService.Check();
        if (ttlConfig.isEnabled()) {
            check.setTtl(ttlConfig.getTtl());
            return check;
        }
        Assert.notNull((Object)port, (String)"createCheck port must not be null");
        Assert.isTrue((port > 0 ? 1 : 0) != 0, (String)"createCheck port must be greater than 0");
        if (properties.getHealthCheckUrl() != null) {
            check.setHttp(properties.getHealthCheckUrl());
        } else {
            check.setHttp(String.format("%s://%s:%s%s", properties.getScheme(), properties.getHostname(), port, properties.getHealthCheckPath()));
        }
        check.setInterval(properties.getHealthCheckInterval());
        check.setTimeout(properties.getHealthCheckTimeout());
        if (StringUtils.hasText((String)properties.getHealthCheckCriticalTimeout())) {
            check.setDeregisterCriticalServiceAfter(properties.getHealthCheckCriticalTimeout());
        }
        check.setTlsSkipVerify(properties.getHealthCheckTlsSkipVerify());
        return check;
    }

    public static String getAppName(ConsulDiscoveryProperties properties, RelaxedPropertyResolver propertyResolver) {
        String appName = properties.getServiceName();
        if (!StringUtils.isEmpty((Object)appName)) {
            return appName;
        }
        return propertyResolver.getProperty("spring.application.name", "application");
    }

    public static boolean shouldRegisterManagement(ConsulDiscoveryProperties properties, ApplicationContext context) {
        return ConsulAutoRegistration.getManagementPort(properties, context) != null && ManagementServerPortUtils.isDifferent((BeanFactory)context);
    }

    public static String getManagementServiceId(ConsulDiscoveryProperties properties, ApplicationContext context) {
        return ConsulAutoRegistration.normalizeForDns(context.getId()) + '-' + properties.getManagementSuffix();
    }

    public static String getManagementServiceName(ConsulDiscoveryProperties properties, RelaxedPropertyResolver propertyResolver) {
        return ConsulAutoRegistration.normalizeForDns(ConsulAutoRegistration.getAppName(properties, propertyResolver)) + '-' + properties.getManagementSuffix();
    }

    public static Integer getManagementPort(ConsulDiscoveryProperties properties, ApplicationContext context) {
        if (properties.getManagementPort() != null) {
            return properties.getManagementPort();
        }
        return ManagementServerPortUtils.getPort((BeanFactory)context);
    }
}

