/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServer;

public class ConsulServerList
extends AbstractServerList<ConsulServer> {
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private String serviceId;

    public ConsulServerList(ConsulClient client, ConsulDiscoveryProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    protected ConsulClient getClient() {
        return this.client;
    }

    protected ConsulDiscoveryProperties getProperties() {
        return this.properties;
    }

    protected String getServiceId() {
        return this.serviceId;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.serviceId = clientConfig.getClientName();
    }

    public List<ConsulServer> getInitialListOfServers() {
        return this.getServers();
    }

    public List<ConsulServer> getUpdatedListOfServers() {
        return this.getServers();
    }

    private List<ConsulServer> getServers() {
        if (this.client == null) {
            return Collections.emptyList();
        }
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(this.getTag()).setPassing(this.properties.isQueryPassing()).setQueryParams(this.createQueryParamsForClientRequest()).setToken(this.properties.getAclToken()).build();
        Response response = this.client.getHealthServices(this.serviceId, request);
        if (response.getValue() == null || ((List)response.getValue()).isEmpty()) {
            return Collections.emptyList();
        }
        return this.transformResponse((List)response.getValue());
    }

    protected List<ConsulServer> transformResponse(List<HealthService> healthServices) {
        ArrayList<ConsulServer> servers = new ArrayList<ConsulServer>();
        for (HealthService service : healthServices) {
            ConsulServer server = new ConsulServer(service, this.properties.isTagsAsMetadata());
            if (server.getMetadata().containsKey(this.properties.getDefaultZoneMetadataName())) {
                server.setZone(server.getMetadata().get(this.properties.getDefaultZoneMetadataName()));
            }
            servers.add(server);
        }
        return servers;
    }

    protected QueryParams createQueryParamsForClientRequest() {
        String datacenter = this.getDatacenter();
        if (datacenter != null) {
            return new QueryParams(datacenter, this.properties.getConsistencyMode());
        }
        return new QueryParams(this.properties.getConsistencyMode());
    }

    protected String getTag() {
        return this.properties.getQueryTagForService(this.serviceId);
    }

    protected String getDatacenter() {
        return this.properties.getDatacenters().get(this.serviceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConsulServerList{");
        sb.append("serviceId='").append(this.serviceId).append('\'');
        sb.append(", tag=").append(this.getTag());
        sb.append('}');
        return sb.toString();
    }
}

