/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import com.ecwid.consul.v1.agent.model.NewService;
import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.ConsulServerUtils;

public class ConsulRegistration
implements Registration {
    private final NewService service;
    private ConsulDiscoveryProperties properties;

    public ConsulRegistration(NewService service, ConsulDiscoveryProperties properties) {
        this.service = service;
        this.properties = properties;
    }

    public NewService getService() {
        return this.service;
    }

    protected ConsulDiscoveryProperties getProperties() {
        return this.properties;
    }

    public String getInstanceId() {
        return this.getService().getId();
    }

    public String getServiceId() {
        return this.getService().getName();
    }

    public String getHost() {
        return this.getService().getAddress();
    }

    public int getPort() {
        return this.getService().getPort();
    }

    public boolean isSecure() {
        return this.properties.getScheme().equalsIgnoreCase("https");
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        if (this.properties.isTagsAsMetadata()) {
            return ConsulServerUtils.getMetadata(this.getService().getTags());
        }
        return this.getService().getMeta();
    }
}

