/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import jakarta.servlet.ServletContext;
import java.util.ArrayList;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistrationCustomizer;
import org.springframework.util.StringUtils;

public class ConsulServletRegistrationCustomizer
implements ConsulRegistrationCustomizer {
    private ObjectProvider<ServletContext> servletContext;

    public ConsulServletRegistrationCustomizer(ObjectProvider<ServletContext> servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void customize(ConsulRegistration registration) {
        if (this.servletContext == null) {
            return;
        }
        ServletContext sc = (ServletContext)this.servletContext.getIfAvailable();
        if (sc != null && StringUtils.hasText((String)sc.getContextPath()) && StringUtils.hasText((String)sc.getContextPath().replaceAll("/", ""))) {
            ArrayList<String> tags = registration.getService().getTags();
            if (tags == null) {
                tags = new ArrayList<String>();
            }
            tags.add("contextPath=" + sc.getContextPath());
            registration.getService().setTags(tags);
        }
    }
}

