/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.context.encrypt.EncryptorFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={TextEncryptor.class})
@EnableConfigurationProperties(value={KeyProperties.class})
public class EncryptionBootstrapConfiguration {
    @Autowired(required=false)
    private TextEncryptor encryptor;
    @Autowired
    private KeyProperties key;

    @Bean
    public EnvironmentDecryptApplicationInitializer environmentDecryptApplicationListener() {
        if (this.encryptor == null) {
            this.encryptor = new FailsafeTextEncryptor();
        }
        EnvironmentDecryptApplicationInitializer listener = new EnvironmentDecryptApplicationInitializer(this.encryptor);
        listener.setFailOnError(this.key.isFailOnError());
        return listener;
    }

    protected static class FailsafeTextEncryptor
    implements TextEncryptor {
        protected FailsafeTextEncryptor() {
        }

        public String encrypt(String text) {
            throw new UnsupportedOperationException("No encryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }

        public String decrypt(String encryptedText) {
            throw new UnsupportedOperationException("No decryption for FailsafeTextEncryptor. Did you configure the keystore correctly?");
        }
    }

    public static class KeyCondition
    extends SpringBootCondition {
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            if (this.hasProperty(environment, "encrypt.keyStore.location")) {
                if (this.hasProperty(environment, "encrypt.keyStore.password")) {
                    return ConditionOutcome.match((String)"Keystore found in Environment");
                }
                return ConditionOutcome.noMatch((String)"Keystore found but no password in Environment");
            }
            if (this.hasProperty(environment, "encrypt.key")) {
                return ConditionOutcome.match((String)"Key found in Environment");
            }
            return ConditionOutcome.noMatch((String)"Keystore nor key found in Environment");
        }

        private boolean hasProperty(Environment environment, String key) {
            String value = environment.getProperty(key);
            if (value == null) {
                return false;
            }
            return StringUtils.hasText((String)environment.resolvePlaceholders(value));
        }
    }

    @Configuration
    @Conditional(value={KeyCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.security.rsa.crypto.RsaSecretEncryptor"})
    protected static class VanillaEncryptionConfiguration {
        @Autowired
        private KeyProperties key;

        protected VanillaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor() {
            return new EncryptorFactory().create(this.key.getKey());
        }
    }

    @Configuration
    @Conditional(value={KeyCondition.class})
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    protected static class RsaEncryptionConfiguration {
        @Autowired
        private KeyProperties key;

        protected RsaEncryptionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={TextEncryptor.class})
        public TextEncryptor textEncryptor() {
            KeyProperties.KeyStore keyStore = this.key.getKeyStore();
            if (keyStore.getLocation() != null && keyStore.getLocation().exists()) {
                return new RsaSecretEncryptor(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()).getKeyPair(keyStore.getAlias(), keyStore.getSecret().toCharArray()), this.key.getRsa().getAlgorithm(), this.key.getRsa().getSalt(), this.key.getRsa().isStrong());
            }
            return new EncryptorFactory().create(this.key.getKey());
        }
    }
}

