/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.scope;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.context.scope.ScopeCache;
import org.springframework.cloud.context.scope.StandardScopeCache;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class GenericScope
implements Scope,
BeanFactoryPostProcessor,
BeanDefinitionRegistryPostProcessor,
DisposableBean {
    private static final Log logger = LogFactory.getLog(GenericScope.class);
    public static final String SCOPED_TARGET_PREFIX = "scopedTarget.";
    private BeanLifecycleWrapperCache cache = new BeanLifecycleWrapperCache(new StandardScopeCache());
    private String name = "generic";
    private ConfigurableListableBeanFactory beanFactory;
    private StandardEvaluationContext evaluationContext;
    private String id;
    private Map<String, Exception> errors = new ConcurrentHashMap<String, Exception>();
    private ConcurrentMap<String, ReadWriteLock> locks = new ConcurrentHashMap<String, ReadWriteLock>();

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScopeCache(ScopeCache cache) {
        this.cache = new BeanLifecycleWrapperCache(cache);
    }

    public Map<String, Exception> getErrors() {
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Collection<BeanLifecycleWrapper> wrappers = this.cache.clear();
        for (BeanLifecycleWrapper wrapper : wrappers) {
            try {
                Lock lock = ((ReadWriteLock)this.locks.get(wrapper.getName())).writeLock();
                lock.lock();
                try {
                    wrapper.destroy();
                }
                finally {
                    lock.unlock();
                }
            }
            catch (RuntimeException e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw GenericScope.wrapIfNecessary((Throwable)errors.get(0));
        }
        this.errors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroy(String name) {
        BeanLifecycleWrapper wrapper = this.cache.remove(name);
        if (wrapper != null) {
            Lock lock = ((ReadWriteLock)this.locks.get(wrapper.getName())).writeLock();
            lock.lock();
            try {
                wrapper.destroy();
            }
            finally {
                lock.unlock();
            }
            this.errors.remove(name);
            return true;
        }
        return false;
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        BeanLifecycleWrapper value = this.cache.put(name, new BeanLifecycleWrapper(name, objectFactory));
        this.locks.putIfAbsent(name, new ReentrantReadWriteLock());
        try {
            return value.getBean();
        }
        catch (RuntimeException e) {
            this.errors.put(name, e);
            throw e;
        }
    }

    public String getConversationId() {
        return this.name;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        BeanLifecycleWrapper value = this.cache.get(name);
        if (value == null) {
            return;
        }
        value.setDestroyCallback(callback);
    }

    public Object remove(String name) {
        BeanLifecycleWrapper value = this.cache.remove(name);
        if (value == null) {
            return null;
        }
        return value.getBean();
    }

    public Object resolveContextualObject(String key) {
        Expression expression = this.parseExpression(key);
        return expression.getValue((EvaluationContext)this.evaluationContext, (Object)this.beanFactory);
    }

    private Expression parseExpression(String input) {
        if (StringUtils.hasText((String)input)) {
            SpelExpressionParser parser = new SpelExpressionParser();
            try {
                return parser.parseExpression(input);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse expression: " + input, e);
            }
        }
        return null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        beanFactory.registerScope(this.name, (Scope)this);
        this.setSerializationId(beanFactory);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        for (String name : registry.getBeanDefinitionNames()) {
            RootBeanDefinition root;
            BeanDefinition definition = registry.getBeanDefinition(name);
            if (!(definition instanceof RootBeanDefinition) || (root = (RootBeanDefinition)definition).getDecoratedDefinition() == null || !root.hasBeanClass() || root.getBeanClass() != ScopedProxyFactoryBean.class || !this.getName().equals(root.getDecoratedDefinition().getBeanDefinition().getScope())) continue;
            root.setBeanClass(LockedScopedProxyFactoryBean.class);
            root.getConstructorArgumentValues().addGenericArgumentValue((Object)this);
        }
    }

    private void setSerializationId(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            String id = this.id;
            if (id == null) {
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(beanFactory.getBeanDefinitionNames()));
                Collections.sort(list);
                String names = ((Object)list).toString();
                logger.debug((Object)("Generating bean factory id from names: " + names));
                id = UUID.nameUUIDFromBytes(names.getBytes()).toString();
            }
            logger.info((Object)("BeanFactory id=" + id));
            ((DefaultListableBeanFactory)beanFactory).setSerializationId(id);
        } else {
            logger.warn((Object)"BeanFactory was not a DefaultListableBeanFactory, scoped proxy beans cannot be serialized.");
        }
    }

    static RuntimeException wrapIfNecessary(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new IllegalStateException(throwable);
    }

    protected String getName() {
        return this.name;
    }

    protected ReadWriteLock getLock(String beanName) {
        return (ReadWriteLock)this.locks.get(beanName);
    }

    public static class LockedScopedProxyFactoryBean<S extends GenericScope>
    extends ScopedProxyFactoryBean
    implements MethodInterceptor {
        private final S scope;
        private String targetBeanName;

        public LockedScopedProxyFactoryBean(S scope) {
            this.scope = scope;
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            super.setBeanFactory(beanFactory);
            Object proxy = this.getObject();
            if (proxy instanceof Advised) {
                Advised advised = (Advised)proxy;
                advised.addAdvice(0, (Advice)this);
            }
        }

        public void setTargetBeanName(String targetBeanName) {
            super.setTargetBeanName(targetBeanName);
            this.targetBeanName = targetBeanName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (AopUtils.isEqualsMethod((Method)method) || AopUtils.isToStringMethod((Method)method) || AopUtils.isHashCodeMethod((Method)method) || this.isScopedObjectGetTargetObject(method)) {
                return invocation.proceed();
            }
            Object proxy = this.getObject();
            Lock lock = ((GenericScope)this.scope).getLock(this.targetBeanName).readLock();
            lock.lock();
            try {
                if (proxy instanceof Advised) {
                    Advised advised = (Advised)proxy;
                    ReflectionUtils.makeAccessible((Method)method);
                    Object object = ReflectionUtils.invokeMethod((Method)method, (Object)advised.getTargetSource().getTarget(), (Object[])invocation.getArguments());
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            finally {
                lock.unlock();
            }
        }

        private boolean isScopedObjectGetTargetObject(Method method) {
            return method.getDeclaringClass().equals(ScopedObject.class) && method.getName().equals("getTargetObject") && method.getParameterTypes().length == 0;
        }
    }

    private static class BeanLifecycleWrapper {
        private Object bean;
        private Runnable callback;
        private final String name;
        private final ObjectFactory<?> objectFactory;

        public BeanLifecycleWrapper(String name, ObjectFactory<?> objectFactory) {
            this.name = name;
            this.objectFactory = objectFactory;
        }

        public String getName() {
            return this.name;
        }

        public void setDestroyCallback(Runnable callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getBean() {
            if (this.bean == null) {
                String string = this.name;
                synchronized (string) {
                    if (this.bean == null) {
                        this.bean = this.objectFactory.getObject();
                    }
                }
            }
            return this.bean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (this.callback == null) {
                return;
            }
            String string = this.name;
            synchronized (string) {
                Runnable callback = this.callback;
                if (callback != null) {
                    callback.run();
                }
                this.callback = null;
                this.bean = null;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanLifecycleWrapper other = (BeanLifecycleWrapper)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static class BeanLifecycleWrapperCache {
        private final ScopeCache cache;

        public BeanLifecycleWrapperCache(ScopeCache cache) {
            this.cache = cache;
        }

        public BeanLifecycleWrapper remove(String name) {
            return (BeanLifecycleWrapper)this.cache.remove(name);
        }

        public Collection<BeanLifecycleWrapper> clear() {
            Collection<Object> values = this.cache.clear();
            LinkedHashSet<BeanLifecycleWrapper> wrappers = new LinkedHashSet<BeanLifecycleWrapper>();
            for (Object object : values) {
                wrappers.add((BeanLifecycleWrapper)object);
            }
            return wrappers;
        }

        public BeanLifecycleWrapper get(String name) {
            return (BeanLifecycleWrapper)this.cache.get(name);
        }

        public BeanLifecycleWrapper put(String name, BeanLifecycleWrapper value) {
            return (BeanLifecycleWrapper)this.cache.put(name, value);
        }
    }
}

