/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetadata;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingPostProcessor;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ConfigurationPropertiesBindingPostProcessor.class})
public class ConfigurationPropertiesRebinderAutoConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public static ConfigurationPropertiesBeans configurationPropertiesBeans(ApplicationContext context) {
        ConfigurationBeanFactoryMetadata metaData = (ConfigurationBeanFactoryMetadata)context.getBean(ConfigurationBeanFactoryMetadata.BEAN_NAME, ConfigurationBeanFactoryMetadata.class);
        ConfigurationPropertiesBeans beans = new ConfigurationPropertiesBeans();
        beans.setBeanMetaDataStore(metaData);
        return beans;
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ConfigurationPropertiesRebinder configurationPropertiesRebinder(ConfigurationPropertiesBeans beans) {
        ConfigurationPropertiesRebinder rebinder = new ConfigurationPropertiesRebinder(beans);
        return rebinder;
    }

    public void afterSingletonsInstantiated() {
        if (this.context.getParent() != null) {
            ConfigurationPropertiesRebinder rebinder = (ConfigurationPropertiesRebinder)this.context.getBean(ConfigurationPropertiesRebinder.class);
            for (String name : this.context.getParent().getBeanDefinitionNames()) {
                rebinder.rebind(name);
            }
        }
    }
}

