/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util;

import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public abstract class PropertyUtils {
    public static final String BOOTSTRAP_ENABLED_PROPERTY = "spring.cloud.bootstrap.enabled";
    public static final String USE_LEGACY_PROCESSING_PROPERTY = "spring.config.use-legacy-processing";
    public static final String MARKER_CLASS = "org.springframework.cloud.bootstrap.marker.Marker";
    public static final boolean MARKER_CLASS_EXISTS = PropertyUtils.markerClassExists();

    private static boolean markerClassExists() {
        try {
            ClassUtils.forName((String)MARKER_CLASS, null);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private PropertyUtils() {
    }

    public static boolean bootstrapEnabled(Environment environment) {
        return (Boolean)environment.getProperty(BOOTSTRAP_ENABLED_PROPERTY, Boolean.class, (Object)false) != false || MARKER_CLASS_EXISTS;
    }

    public static boolean useLegacyProcessing(Environment environment) {
        return (Boolean)environment.getProperty(USE_LEGACY_PROCESSING_PROPERTY, Boolean.class, (Object)false);
    }
}

