/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.Bootstrapper;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.RsaProperties;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public class TextEncryptorConfigBootstrapper
implements Bootstrapper {
    public static final boolean RSA_IS_PRESENT = ClassUtils.isPresent((String)"org.springframework.security.rsa.crypto.RsaSecretEncryptor", null);

    public void intitialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.security.crypto.encrypt.TextEncryptor", null)) {
            return;
        }
        registry.registerIfAbsent(KeyProperties.class, context -> (KeyProperties)((Binder)context.get(Binder.class)).bind("encrypt", KeyProperties.class).orElseGet(KeyProperties::new));
        if (RSA_IS_PRESENT) {
            registry.registerIfAbsent(RsaProperties.class, context -> (RsaProperties)((Binder)context.get(Binder.class)).bind("encrypt.rsa", RsaProperties.class).orElseGet(RsaProperties::new));
        }
        TextEncryptorUtils.register(registry);
        registry.addCloseListener(event -> {
            RsaProperties rsaProperties;
            if (TextEncryptorUtils.isLegacyBootstrap((Environment)event.getApplicationContext().getEnvironment())) {
                return;
            }
            BootstrapContext bootstrapContext = event.getBootstrapContext();
            KeyProperties keyProperties = (KeyProperties)bootstrapContext.get(KeyProperties.class);
            ConfigurableListableBeanFactory beanFactory = event.getApplicationContext().getBeanFactory();
            if (keyProperties != null) {
                beanFactory.registerSingleton("keyProperties", (Object)keyProperties);
            }
            if (RSA_IS_PRESENT && (rsaProperties = (RsaProperties)bootstrapContext.get(RsaProperties.class)) != null) {
                beanFactory.registerSingleton("rsaProperties", (Object)rsaProperties);
            }
            TextEncryptorUtils.promote(bootstrapContext, beanFactory);
        });
    }

    @Deprecated
    public static boolean keysConfigured(KeyProperties properties) {
        return TextEncryptorUtils.keysConfigured(properties);
    }

    @Deprecated
    public static class FailsafeTextEncryptor
    extends TextEncryptorUtils.FailsafeTextEncryptor {
    }
}

