/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.springframework.util.StringUtils;

@CacheableTask
class GenerateClientStubsFromDslTask
extends DefaultTask {
    static final String TASK_NAME = "generateClientStubs";
    static final String DEFAULT_MAPPINGS_FOLDER = "mappings";
    private final Property<Directory> contractsDslDir;
    private final ListProperty<String> excludedFiles;
    private final Property<Boolean> excludeBuildFolders;
    private final ConfigurableFileCollection classpath;
    private final DirectoryProperty stubsOutputDir;

    @Inject
    public GenerateClientStubsFromDslTask(ObjectFactory objects) {
        this.contractsDslDir = objects.directoryProperty();
        this.excludedFiles = objects.listProperty(String.class);
        this.excludeBuildFolders = objects.property(Boolean.class);
        this.classpath = objects.fileCollection();
        this.stubsOutputDir = objects.directoryProperty();
    }

    @TaskAction
    void generate() {
        File output = ((Directory)this.stubsOutputDir.get()).getAsFile();
        this.getLogger().info("Stubs output dir [{}]", (Object)output);
        this.getLogger().info("Spring Cloud Contract Verifier Plugin: Invoking DSL to client stubs conversion");
        this.getLogger().info("Contracts dir is [{}] output stubs dir is [{}]", (Object)((Directory)this.contractsDslDir.get()).getAsFile(), (Object)output);
        ByteArrayOutputStream os = this.getLogger().isDebugEnabled() ? new ByteArrayOutputStream() : NullOutputStream.INSTANCE;
        this.getProject().javaexec(exec -> {
            exec.setMain("org.springframework.cloud.contract.verifier.converter.RecursiveFilesConverterApplication");
            exec.classpath(new Object[]{this.classpath});
            exec.args(new Object[]{this.quoteAndEscape(output.getAbsolutePath()), this.quoteAndEscape(((Directory)this.contractsDslDir.get()).getAsFile().getAbsolutePath()), this.quoteAndEscape(StringUtils.collectionToCommaDelimitedString((Collection)((Collection)this.excludedFiles.get()))), this.quoteAndEscape(".*"), this.excludeBuildFolders.get()});
            exec.setStandardOutput(os);
            exec.setErrorOutput(os);
        });
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug(((Object)os).toString());
        }
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Property<Directory> getContractsDslDir() {
        return this.contractsDslDir;
    }

    @Input
    public ListProperty<String> getExcludedFiles() {
        return this.excludedFiles;
    }

    @Input
    public Property<Boolean> getExcludeBuildFolders() {
        return this.excludeBuildFolders;
    }

    @Classpath
    public ConfigurableFileCollection getClasspath() {
        return this.classpath;
    }

    @OutputDirectory
    public Property<Directory> getStubsOutputDir() {
        return this.stubsOutputDir;
    }

    private String quoteAndEscape(String str) {
        if (System.getProperty("os.name").contains("Windows")) {
            return "\"" + str.replace("\"", "\\\"") + "\"";
        }
        return str;
    }
}

