/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CopyContracts {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MavenProject project;
    private final MavenSession mavenSession;
    private final MavenResourcesFiltering mavenResourcesFiltering;

    public CopyContracts(MavenProject project, MavenSession mavenSession, MavenResourcesFiltering mavenResourcesFiltering) {
        this.project = project;
        this.mavenSession = mavenSession;
        this.mavenResourcesFiltering = mavenResourcesFiltering;
    }

    public void copy(File contractsDirectory, File outputDirectory) throws MojoExecutionException {
        log.info("Copying Spring Cloud Contract Verifier contracts");
        Resource resource = new Resource();
        resource.setDirectory(contractsDirectory.getAbsolutePath());
        MavenResourcesExecution execution = new MavenResourcesExecution();
        execution.setResources(Collections.singletonList(resource));
        execution.setOutputDirectory(new File(outputDirectory, "contracts"));
        execution.setMavenProject(this.project);
        execution.setEncoding("UTF-8");
        execution.setMavenSession(this.mavenSession);
        execution.setInjectProjectBuildFilters(false);
        execution.setOverwrite(true);
        execution.setIncludeEmptyDirs(false);
        execution.setFilterFilenames(false);
        try {
            this.mavenResourcesFiltering.filterResources(execution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

