/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.springframework.cloud.contract.maven.verifier.stubrunner.AetherStubDownloaderFactory;
import org.springframework.cloud.contract.stubrunner.AetherStubDownloader;
import org.springframework.cloud.contract.stubrunner.ContractDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.util.StringUtils;

class MavenContractsDownloader {
    private static final String LATEST_VERSION = "+";
    private static final String CONTRACTS_DIRECTORY_PROP = "CONTRACTS_DIRECTORY";
    private final MavenProject project;
    private final Dependency contractDependency;
    private final String contractsPath;
    private final String contractsRepositoryUrl;
    private final boolean contractsWorkOffline;
    private final Log log;
    private final AetherStubDownloaderFactory aetherStubDownloaderFactory;
    private final RepositorySystemSession repoSession;

    MavenContractsDownloader(MavenProject project, Dependency contractDependency, String contractsPath, String contractsRepositoryUrl, boolean contractsWorkOffline, Log log, AetherStubDownloaderFactory aetherStubDownloaderFactory, RepositorySystemSession repoSession) {
        this.project = project;
        this.contractDependency = contractDependency;
        this.contractsPath = contractsPath;
        this.contractsRepositoryUrl = contractsRepositoryUrl;
        this.contractsWorkOffline = contractsWorkOffline;
        this.log = log;
        this.aetherStubDownloaderFactory = aetherStubDownloaderFactory;
        this.repoSession = repoSession;
    }

    File downloadAndUnpackContractsIfRequired(ContractVerifierConfigProperties config, File defaultContractsDir) {
        File downloadedContractsDir;
        String contractsDirFromProp = this.project.getProperties().getProperty(CONTRACTS_DIRECTORY_PROP);
        File file = downloadedContractsDir = StringUtils.hasText((String)contractsDirFromProp) ? new File(contractsDirFromProp) : null;
        if (downloadedContractsDir != null && downloadedContractsDir.exists()) {
            this.log.info((CharSequence)("Another mojo has downloaded the contracts - will reuse them from [" + downloadedContractsDir + "]"));
            this.contractDownloader().updatePropertiesWithInclusion(downloadedContractsDir, config);
            return downloadedContractsDir;
        }
        if (this.shouldDownloadContracts()) {
            this.log.info((CharSequence)"Download dependency is provided - will download contract jars");
            File downloadedContracts = this.contractDownloader().unpackedDownloadedContracts(config);
            this.project.getProperties().setProperty(CONTRACTS_DIRECTORY_PROP, downloadedContracts.getAbsolutePath());
            return downloadedContracts;
        }
        this.log.info((CharSequence)("Will use contracts provided in the folder [" + defaultContractsDir + "]"));
        return defaultContractsDir;
    }

    private boolean shouldDownloadContracts() {
        return this.contractDependency != null && StringUtils.hasText((String)this.contractDependency.getArtifactId());
    }

    private ContractDownloader contractDownloader() {
        return new ContractDownloader((StubDownloader)this.stubDownloader(), this.stubConfiguration(), this.contractsPath, this.project.getGroupId(), this.project.getArtifactId());
    }

    private AetherStubDownloader stubDownloader() {
        if (StringUtils.hasText((String)this.contractsRepositoryUrl) || this.contractsWorkOffline) {
            this.log.info((CharSequence)("Will download contracts from [" + this.contractsRepositoryUrl + "]. " + "Work offline switch equals to [" + this.contractsWorkOffline + "]"));
            return new AetherStubDownloader(new StubRunnerOptionsBuilder().withStubRepositoryRoot(this.contractsRepositoryUrl).withWorkOffline(this.contractsWorkOffline).build());
        }
        this.log.info((CharSequence)"Will download contracts using current build's Maven repository setup");
        return this.aetherStubDownloaderFactory.build(this.repoSession);
    }

    private StubConfiguration stubConfiguration() {
        String groupId = this.contractDependency.getGroupId();
        String artifactId = this.contractDependency.getArtifactId();
        String version = StringUtils.hasText((String)this.contractDependency.getVersion()) ? this.contractDependency.getVersion() : LATEST_VERSION;
        String classifier = this.contractDependency.getClassifier();
        return new StubConfiguration(groupId, artifactId, version, classifier);
    }
}

