/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.maven.verifier;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.springframework.cloud.contract.maven.verifier.ManifestCreator;

@Mojo(name="generateStubs", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true)
public class GenerateStubsMojo
extends AbstractMojo {
    private static final String STUB_MAPPING_FILE_PATTERN = "**/*.json";
    private static final String CONTRACT_FILE_PATTERN = "**/*.groovy";
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File projectBuildDirectory;
    @Parameter(property="stubsDirectory", defaultValue="${project.build.directory}/stubs")
    private File outputDirectory;
    @Parameter(property="spring.cloud.contract.verifier.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="spring.cloud.contract.verifier.jar.skip", defaultValue="false")
    private boolean jarSkip;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter
    private String[] excludedFiles;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver archiver;
    @Parameter(defaultValue="true")
    private boolean attachContracts;
    @Parameter(defaultValue="stubs")
    private String classifier;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.jarSkip) {
            this.getLog().info((CharSequence)("Skipping Spring Cloud Contract Verifier execution: spring.cloud.contract.verifier.skip=" + this.skip + ", spring.cloud.contract.verifier.jar.skip=" + this.jarSkip));
            return;
        }
        File stubsJarFile = this.createStubJar(this.outputDirectory);
        this.projectHelper.attachArtifact(this.project, "jar", this.classifier, stubsJarFile);
    }

    private File createStubJar(File stubsOutputDir) throws MojoFailureException, MojoExecutionException {
        if (!stubsOutputDir.exists()) {
            throw new MojoExecutionException("Stubs could not be found: [" + stubsOutputDir.getAbsolutePath() + "] .\nPlease make sure that spring-cloud-contract:convert was invoked");
        }
        String stubArchiveName = this.project.getBuild().getFinalName() + "-" + this.classifier + ".jar";
        File stubsJarFile = new File(this.projectBuildDirectory, stubArchiveName);
        Object[] excludes = this.excludes();
        this.getLog().info((CharSequence)("Files matching this pattern will be excluded from stubs generation " + Arrays.toString(excludes)));
        try {
            if (this.attachContracts) {
                this.archiver.addDirectory(stubsOutputDir, new String[]{STUB_MAPPING_FILE_PATTERN, CONTRACT_FILE_PATTERN}, this.excludedFilesEmpty() ? new String[]{} : this.excludedFiles);
            } else {
                this.getLog().info((CharSequence)"Skipping attaching Spring Cloud Contract Verifier contracts");
                this.archiver.addDirectory(stubsOutputDir, new String[]{STUB_MAPPING_FILE_PATTERN}, (String[])excludes);
            }
            this.archiver.setCompress(true);
            this.archiver.setDestFile(stubsJarFile);
            this.archiver.addConfiguredManifest(ManifestCreator.createManifest(this.project));
            this.archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoFailureException("Exception while packaging " + this.classifier + " jar.", (Throwable)e);
        }
        return stubsJarFile;
    }

    private String[] excludes() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add(CONTRACT_FILE_PATTERN);
        if (!this.excludedFilesEmpty()) {
            excludes.addAll(Arrays.asList(this.excludedFiles));
        }
        String[] array = new String[excludes.size()];
        array = excludes.toArray(array);
        return array;
    }

    private boolean excludedFilesEmpty() {
        return this.excludedFiles == null || this.excludedFiles.length == 0;
    }
}

